"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
var _exportNames = {
  TITLE: true,
  DESCRIPTION: true,
  NO_CUSTOM_FIELDS: true,
  ADD_CUSTOM_FIELD: true,
  MAX_CUSTOM_FIELD_LIMIT: true,
  SAVE_FIELD: true,
  FIELD_LABEL: true,
  FIELD_LABEL_HELP_TEXT: true,
  TEXT_LABEL: true,
  TOGGLE_LABEL: true,
  FIELD_TYPE: true,
  FIELD_OPTIONS: true,
  DEFAULT_VALUE: true,
  FIELD_OPTION_REQUIRED: true,
  REQUIRED: true,
  REQUIRED_FIELD: true,
  EDIT_CUSTOM_FIELDS_ARIA_LABEL: true,
  NO_CUSTOM_FIELD_SET: true,
  DELETE_FIELD_TITLE: true,
  DELETE_FIELD_DESCRIPTION: true,
  DELETE: true,
  TOGGLE_FIELD_ON_LABEL: true,
  TOGGLE_FIELD_OFF_LABEL: true,
  POPULATED_WITH_DEFAULT: true
};
exports.TOGGLE_LABEL = exports.TOGGLE_FIELD_ON_LABEL = exports.TOGGLE_FIELD_OFF_LABEL = exports.TITLE = exports.TEXT_LABEL = exports.SAVE_FIELD = exports.REQUIRED_FIELD = exports.REQUIRED = exports.POPULATED_WITH_DEFAULT = exports.NO_CUSTOM_FIELD_SET = exports.NO_CUSTOM_FIELDS = exports.MAX_CUSTOM_FIELD_LIMIT = exports.FIELD_TYPE = exports.FIELD_OPTION_REQUIRED = exports.FIELD_OPTIONS = exports.FIELD_LABEL_HELP_TEXT = exports.FIELD_LABEL = exports.EDIT_CUSTOM_FIELDS_ARIA_LABEL = exports.DESCRIPTION = exports.DELETE_FIELD_TITLE = exports.DELETE_FIELD_DESCRIPTION = exports.DELETE = exports.DEFAULT_VALUE = exports.ADD_CUSTOM_FIELD = void 0;
var _i18n = require("@kbn/i18n");
var _translations = require("../../common/translations");
Object.keys(_translations).forEach(function (key) {
  if (key === "default" || key === "__esModule") return;
  if (Object.prototype.hasOwnProperty.call(_exportNames, key)) return;
  if (key in exports && exports[key] === _translations[key]) return;
  Object.defineProperty(exports, key, {
    enumerable: true,
    get: function () {
      return _translations[key];
    }
  });
});
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const TITLE = exports.TITLE = _i18n.i18n.translate('xpack.cases.customFields.title', {
  defaultMessage: 'Custom fields'
});
const DESCRIPTION = exports.DESCRIPTION = _i18n.i18n.translate('xpack.cases.customFields.description', {
  defaultMessage: 'Add more optional and required fields for customized case collaboration.'
});
const NO_CUSTOM_FIELDS = exports.NO_CUSTOM_FIELDS = _i18n.i18n.translate('xpack.cases.customFields.noCustomFields', {
  defaultMessage: 'You do not have any fields yet'
});
const ADD_CUSTOM_FIELD = exports.ADD_CUSTOM_FIELD = _i18n.i18n.translate('xpack.cases.customFields.addCustomField', {
  defaultMessage: 'Add field'
});
const MAX_CUSTOM_FIELD_LIMIT = maxCustomFields => _i18n.i18n.translate('xpack.cases.customFields.maxCustomFieldLimit', {
  values: {
    maxCustomFields
  },
  defaultMessage: 'Maximum number of {maxCustomFields} custom fields reached.'
});
exports.MAX_CUSTOM_FIELD_LIMIT = MAX_CUSTOM_FIELD_LIMIT;
const SAVE_FIELD = exports.SAVE_FIELD = _i18n.i18n.translate('xpack.cases.customFields.saveField', {
  defaultMessage: 'Save field'
});
const FIELD_LABEL = exports.FIELD_LABEL = _i18n.i18n.translate('xpack.cases.customFields.fieldLabel', {
  defaultMessage: 'Field label'
});
const FIELD_LABEL_HELP_TEXT = exports.FIELD_LABEL_HELP_TEXT = _i18n.i18n.translate('xpack.cases.customFields.fieldLabelHelpText', {
  defaultMessage: '50 characters max'
});
const TEXT_LABEL = exports.TEXT_LABEL = _i18n.i18n.translate('xpack.cases.customFields.textLabel', {
  defaultMessage: 'Text'
});
const TOGGLE_LABEL = exports.TOGGLE_LABEL = _i18n.i18n.translate('xpack.cases.customFields.toggleLabel', {
  defaultMessage: 'Toggle'
});
const FIELD_TYPE = exports.FIELD_TYPE = _i18n.i18n.translate('xpack.cases.customFields.fieldType', {
  defaultMessage: 'Field type'
});
const FIELD_OPTIONS = exports.FIELD_OPTIONS = _i18n.i18n.translate('xpack.cases.customFields.fieldOptions', {
  defaultMessage: 'Options'
});
const DEFAULT_VALUE = exports.DEFAULT_VALUE = _i18n.i18n.translate('xpack.cases.customFields.defaultValue', {
  defaultMessage: 'Default value'
});
const FIELD_OPTION_REQUIRED = exports.FIELD_OPTION_REQUIRED = _i18n.i18n.translate('xpack.cases.customFields.fieldOptions.Required', {
  defaultMessage: 'Make this field required'
});
const REQUIRED = exports.REQUIRED = _i18n.i18n.translate('xpack.cases.customFields.required', {
  defaultMessage: 'Required'
});
const REQUIRED_FIELD = fieldName => _i18n.i18n.translate('xpack.cases.customFields.requiredField', {
  values: {
    fieldName
  },
  defaultMessage: '{fieldName} is required.'
});
exports.REQUIRED_FIELD = REQUIRED_FIELD;
const EDIT_CUSTOM_FIELDS_ARIA_LABEL = customFieldLabel => _i18n.i18n.translate('xpack.cases.caseView.editCustomFieldsAriaLabel', {
  values: {
    customFieldLabel
  },
  defaultMessage: 'click to edit {customFieldLabel}'
});
exports.EDIT_CUSTOM_FIELDS_ARIA_LABEL = EDIT_CUSTOM_FIELDS_ARIA_LABEL;
const NO_CUSTOM_FIELD_SET = exports.NO_CUSTOM_FIELD_SET = _i18n.i18n.translate('xpack.cases.caseView.noCustomFieldSet', {
  defaultMessage: 'No value is added'
});
const DELETE_FIELD_TITLE = fieldName => _i18n.i18n.translate('xpack.cases.customFields.deleteField', {
  values: {
    fieldName
  },
  defaultMessage: 'Delete field "{fieldName}"?'
});
exports.DELETE_FIELD_TITLE = DELETE_FIELD_TITLE;
const DELETE_FIELD_DESCRIPTION = exports.DELETE_FIELD_DESCRIPTION = _i18n.i18n.translate('xpack.cases.customFields.deleteFieldDescription', {
  defaultMessage: 'The field will be removed from all cases and data will be lost.'
});
const DELETE = exports.DELETE = _i18n.i18n.translate('xpack.cases.customFields.fieldOptions.Delete', {
  defaultMessage: 'Delete'
});
const TOGGLE_FIELD_ON_LABEL = exports.TOGGLE_FIELD_ON_LABEL = _i18n.i18n.translate('xpack.cases.customFields.tableFilters.toggle.on', {
  defaultMessage: 'On'
});
const TOGGLE_FIELD_OFF_LABEL = exports.TOGGLE_FIELD_OFF_LABEL = _i18n.i18n.translate('xpack.cases.customFields.tableFilters.toggle.off', {
  defaultMessage: 'Off'
});
const POPULATED_WITH_DEFAULT = exports.POPULATED_WITH_DEFAULT = _i18n.i18n.translate('xpack.cases.customFields.fieldOptions.populatedWithDefault', {
  defaultMessage: 'This field is populated with the default value.'
});