"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CaseViewTabs = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _react2 = require("@emotion/react");
var _types = require("../../../common/types");
var _navigation = require("../../common/navigation");
var _use_cases_context = require("../cases_context/use_cases_context");
var _translations = require("../header_page/translations");
var _translations2 = require("./translations");
var _use_get_case_file_stats = require("../../containers/use_get_case_file_stats");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const TabTitle = ({
  title
}) => /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
  size: "xxs"
}, /*#__PURE__*/_react.default.createElement("h2", {
  className: "eui-displayInline"
}, title));
TabTitle.displayName = 'TabTitle';
const FilesBadge = ({
  activeTab,
  fileStatsData,
  isLoading,
  euiTheme
}) => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, !isLoading && fileStatsData && /*#__PURE__*/_react.default.createElement(_eui.EuiNotificationBadge, {
  css: (0, _react2.css)`
          margin-left: ${euiTheme.size.xs};
        `,
  "data-test-subj": "case-view-files-stats-badge",
  color: activeTab === _types.CASE_VIEW_PAGE_TABS.FILES ? 'accent' : 'subdued'
}, fileStatsData.total > 0 ? fileStatsData.total : 0));
FilesBadge.displayName = 'FilesBadge';
const AlertsBadge = ({
  activeTab,
  totalAlerts,
  isExperimental,
  euiTheme
}) => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiNotificationBadge, {
  css: (0, _react2.css)`
        margin-left: ${euiTheme.size.xs};
      `,
  "data-test-subj": "case-view-alerts-stats-badge",
  color: activeTab === _types.CASE_VIEW_PAGE_TABS.ALERTS ? 'accent' : 'subdued'
}, totalAlerts || 0), isExperimental && /*#__PURE__*/_react.default.createElement(_eui.EuiBetaBadge, {
  label: _translations.EXPERIMENTAL_LABEL,
  size: "s",
  iconType: "beaker",
  tooltipContent: _translations.EXPERIMENTAL_DESC,
  tooltipPosition: "bottom",
  css: (0, _react2.css)`
          margin-left: ${euiTheme.size.xs};
        `,
  "data-test-subj": "case-view-alerts-table-experimental-badge"
}));
AlertsBadge.displayName = 'AlertsBadge';
const CaseViewTabs = exports.CaseViewTabs = /*#__PURE__*/_react.default.memo(({
  caseData,
  activeTab
}) => {
  const {
    features
  } = (0, _use_cases_context.useCasesContext)();
  const {
    navigateToCaseView
  } = (0, _navigation.useCaseViewNavigation)();
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const {
    data: fileStatsData,
    isLoading
  } = (0, _use_get_case_file_stats.useGetCaseFileStats)({
    caseId: caseData.id
  });
  const tabs = (0, _react.useMemo)(() => [{
    id: _types.CASE_VIEW_PAGE_TABS.ACTIVITY,
    name: _translations2.ACTIVITY_TAB
  }, ...(features.alerts.enabled ? [{
    id: _types.CASE_VIEW_PAGE_TABS.ALERTS,
    name: _translations2.ALERTS_TAB,
    badge: /*#__PURE__*/_react.default.createElement(AlertsBadge, {
      isExperimental: features.alerts.isExperimental,
      totalAlerts: caseData.totalAlerts,
      activeTab: activeTab,
      euiTheme: euiTheme
    })
  }] : []), {
    id: _types.CASE_VIEW_PAGE_TABS.FILES,
    name: _translations2.FILES_TAB,
    badge: /*#__PURE__*/_react.default.createElement(FilesBadge, {
      isLoading: isLoading,
      fileStatsData: fileStatsData,
      activeTab: activeTab,
      euiTheme: euiTheme
    })
  }], [features.alerts.enabled, features.alerts.isExperimental, caseData.totalAlerts, activeTab, isLoading, fileStatsData, euiTheme]);
  const renderTabs = (0, _react.useCallback)(() => {
    return tabs.map((tab, index) => {
      var _tab$badge;
      return /*#__PURE__*/_react.default.createElement(_eui.EuiTab, {
        "data-test-subj": `case-view-tab-title-${tab.id}`,
        key: index,
        onClick: () => navigateToCaseView({
          detailName: caseData.id,
          tabId: tab.id
        }),
        isSelected: tab.id === activeTab
      }, /*#__PURE__*/_react.default.createElement(TabTitle, {
        title: tab.name
      }), (_tab$badge = tab.badge) !== null && _tab$badge !== void 0 ? _tab$badge : null);
    });
  }, [activeTab, caseData.id, navigateToCaseView, tabs]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTabs, {
    "data-test-subj": "case-view-tabs"
  }, renderTabs()), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }));
});
CaseViewTabs.displayName = 'CaseViewTabs';