"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CasesMetrics = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _prettyMs = _interopRequireDefault(require("pretty-ms"));
var _domain = require("../../../common/types/domain");
var _use_get_cases_status = require("../../containers/use_get_cases_status");
var _status_stats = require("../status/status_stats");
var _use_get_cases_metrics = require("../../containers/use_get_cases_metrics");
var _translations = require("./translations");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const CasesMetrics = () => {
  const {
    data: {
      countOpenCases,
      countInProgressCases,
      countClosedCases
    } = {
      countOpenCases: 0,
      countInProgressCases: 0,
      countClosedCases: 0
    },
    isLoading: isCasesStatusLoading
  } = (0, _use_get_cases_status.useGetCasesStatus)();
  const {
    data: {
      mttr
    } = {
      mttr: 0
    },
    isLoading: isCasesMetricsLoading
  } = (0, _use_get_cases_metrics.useGetCasesMetrics)();
  const mttrValue = (0, _react.useMemo)(() => mttr != null ? (0, _prettyMs.default)(mttr * 1000, {
    compact: true,
    verbose: false
  }) : '-', [mttr]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: true,
    paddingSize: "m",
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    responsive: true,
    "data-test-subj": "cases-metrics-stats"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true
  }, /*#__PURE__*/_react.default.createElement(_status_stats.StatusStats, {
    dataTestSubj: "openStatsHeader",
    caseCount: countOpenCases,
    caseStatus: _domain.CaseStatuses.open,
    isLoading: isCasesStatusLoading
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true
  }, /*#__PURE__*/_react.default.createElement(_status_stats.StatusStats, {
    dataTestSubj: "inProgressStatsHeader",
    caseCount: countInProgressCases,
    caseStatus: _domain.CaseStatuses['in-progress'],
    isLoading: isCasesStatusLoading
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true
  }, /*#__PURE__*/_react.default.createElement(_status_stats.StatusStats, {
    dataTestSubj: "closedStatsHeader",
    caseCount: countClosedCases,
    caseStatus: _domain.CaseStatuses.closed,
    isLoading: isCasesStatusLoading
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiStat, {
    "data-test-subj": 'mttrStatsHeader',
    description: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, _translations.ATTC_STAT, "\xA0", /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
      content: _translations.ATTC_DESCRIPTION,
      position: "right",
      "aria-label": _translations.ATTC_STAT_INFO_ARIA_LABEL
    })),
    title: isCasesMetricsLoading ? /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
      "data-test-subj": `mttr-stat-loading-spinner`
    }) : mttrValue,
    titleSize: "xs",
    "text-align": "left"
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }));
};
exports.CasesMetrics = CasesMetrics;
CasesMetrics.displayName = 'CasesMetrics';