"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.testQueryClient = exports.mockedTestProvidersOwner = exports.createAppMockRenderer = exports.TestProviders = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactRouterDom = require("react-router-dom");
var _react2 = require("@testing-library/react");
var _sharedUxFileMocks = require("@kbn/shared-ux-file-mocks");
var _reactQuery = require("@tanstack/react-query");
var _public = require("@kbn/kibana-react-plugin/public");
var _sharedUxFileContext = require("@kbn/shared-ux-file-context");
var _mocks = require("@kbn/core/public/mocks");
var _reactKibanaContextRender = require("@kbn/react-kibana-context-render");
var _constants = require("../../../common/constants");
var _cases_context = require("../../components/cases_context");
var _kibana_react = require("../lib/kibana/kibana_react.mock");
var _external_reference_registry = require("../../client/attachment_framework/external_reference_registry");
var _persistable_state_registry = require("../../client/attachment_framework/persistable_state_registry");
var _permissions = require("./permissions");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/* eslint-disable no-console */

window.scrollTo = jest.fn();
const mockGetFilesClient = () => {
  const mockedFilesClient = (0, _sharedUxFileMocks.createMockFilesClient)();
  mockedFilesClient.getFileKind.mockImplementation(() => ({
    id: 'test',
    maxSizeBytes: 10000,
    http: {}
  }));
  return () => mockedFilesClient;
};
const mockedTestProvidersOwner = exports.mockedTestProvidersOwner = [_constants.SECURITY_SOLUTION_OWNER];

/** A utility for wrapping children in the providers required to run most tests */
const TestProvidersComponent = ({
  children,
  features,
  owner = mockedTestProvidersOwner,
  permissions = (0, _permissions.allCasesPermissions)(),
  releasePhase = 'ga',
  externalReferenceAttachmentTypeRegistry = new _external_reference_registry.ExternalReferenceAttachmentTypeRegistry(),
  persistableStateAttachmentTypeRegistry = new _persistable_state_registry.PersistableStateAttachmentTypeRegistry(),
  license
}) => {
  const coreStart = (0, _react.useMemo)(() => _mocks.coreMock.createStart(), []);
  const services = (0, _react.useMemo)(() => (0, _kibana_react.createStartServicesMock)({
    license
  }), [license]);
  const queryClient = new _reactQuery.QueryClient({
    defaultOptions: {
      queries: {
        retry: false
      }
    },
    logger: {
      log: console.log,
      warn: console.warn,
      error: () => {}
    }
  });
  const getFilesClient = mockGetFilesClient();
  return /*#__PURE__*/_react.default.createElement(_reactKibanaContextRender.KibanaRenderContextProvider, {
    i18n: coreStart.i18n,
    theme: coreStart.theme
  }, /*#__PURE__*/_react.default.createElement(_public.KibanaContextProvider, {
    services: services
  }, /*#__PURE__*/_react.default.createElement(_reactRouterDom.MemoryRouter, null, /*#__PURE__*/_react.default.createElement(_cases_context.CasesProvider, {
    value: {
      externalReferenceAttachmentTypeRegistry,
      persistableStateAttachmentTypeRegistry,
      features,
      owner,
      permissions,
      getFilesClient
    },
    queryClient: queryClient
  }, /*#__PURE__*/_react.default.createElement(_sharedUxFileContext.FilesContext, {
    client: (0, _sharedUxFileMocks.createMockFilesClient)()
  }, children)))));
};
TestProvidersComponent.displayName = 'TestProviders';
const TestProviders = exports.TestProviders = /*#__PURE__*/_react.default.memo(TestProvidersComponent);
const testQueryClient = exports.testQueryClient = new _reactQuery.QueryClient({
  defaultOptions: {
    queries: {
      retry: false
    }
  },
  /**
   * React query prints the errors in the console even though
   * all tests are passings. We turn them off for testing.
   */
  logger: {
    log: console.log,
    warn: console.warn,
    error: () => {}
  }
});
const createAppMockRenderer = ({
  features,
  owner = mockedTestProvidersOwner,
  permissions = (0, _permissions.allCasesPermissions)(),
  releasePhase = 'ga',
  externalReferenceAttachmentTypeRegistry = new _external_reference_registry.ExternalReferenceAttachmentTypeRegistry(),
  persistableStateAttachmentTypeRegistry = new _persistable_state_registry.PersistableStateAttachmentTypeRegistry(),
  license
} = {}) => {
  const coreStart = _mocks.coreMock.createStart();
  const services = (0, _kibana_react.createStartServicesMock)({
    license
  });
  const queryClient = new _reactQuery.QueryClient({
    defaultOptions: {
      queries: {
        retry: false
      }
    },
    logger: {
      log: console.log,
      warn: console.warn,
      error: () => {}
    }
  });
  const getFilesClient = mockGetFilesClient();
  const AppWrapper = ({
    children
  }) => /*#__PURE__*/_react.default.createElement(_reactKibanaContextRender.KibanaRenderContextProvider, {
    i18n: coreStart.i18n,
    theme: coreStart.theme
  }, /*#__PURE__*/_react.default.createElement(_public.KibanaContextProvider, {
    services: services
  }, /*#__PURE__*/_react.default.createElement(_reactRouterDom.MemoryRouter, null, /*#__PURE__*/_react.default.createElement(_cases_context.CasesProvider, {
    value: {
      externalReferenceAttachmentTypeRegistry,
      persistableStateAttachmentTypeRegistry,
      features,
      owner,
      permissions,
      releasePhase,
      getFilesClient
    },
    queryClient: queryClient
  }, children))));
  AppWrapper.displayName = 'AppWrapper';
  const render = (ui, options) => {
    return (0, _react2.render)(ui, {
      wrapper: AppWrapper,
      ...options
    });
  };
  const clearQueryCache = async () => {
    queryClient.getQueryCache().clear();
    await (0, _react2.waitFor)(() => expect(queryClient.isFetching()).toBe(0));
  };
  return {
    coreStart: services,
    queryClient,
    render,
    AppWrapper,
    externalReferenceAttachmentTypeRegistry,
    persistableStateAttachmentTypeRegistry,
    getFilesClient,
    clearQueryCache
  };
};
exports.createAppMockRenderer = createAppMockRenderer;