"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.constructOwnerFromFileKind = exports.constructFilesHttpOperationTag = exports.constructFileKindIdByOwner = exports.CaseFileMetadataForDeletionRt = void 0;
var rt = _interopRequireWildcard(require("io-ts"));
var _lodash = require("lodash");
var _constants = require("../constants");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * This type is only used to validate for deletion, it does not check all the fields that should exist in the file
 * metadata.
 */
const CaseFileMetadataForDeletionRt = exports.CaseFileMetadataForDeletionRt = rt.strict({
  caseIds: rt.array(rt.string)
});
const FILE_KIND_DELIMITER = 'FilesCases';
const constructFilesHttpOperationTag = (owner, operation) => {
  return `${owner}${FILE_KIND_DELIMITER}${operation}`;
};
exports.constructFilesHttpOperationTag = constructFilesHttpOperationTag;
const constructFileKindIdByOwner = owner => `${owner}${FILE_KIND_DELIMITER}`;
exports.constructFileKindIdByOwner = constructFileKindIdByOwner;
const constructOwnerFromFileKind = fileKind => {
  const splitString = fileKind.split(FILE_KIND_DELIMITER);
  if (splitString.length === 2 && (0, _lodash.isEmpty)(splitString[1]) && isValidOwner(splitString[0])) {
    return splitString[0];
  }
};
exports.constructOwnerFromFileKind = constructOwnerFromFileKind;
const isValidOwner = ownerToValidate => {
  const foundOwner = _constants.OWNERS.find(validOwner => validOwner === ownerToValidate);
  return foundOwner !== undefined;
};