"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SimpleTemplate = void 0;
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _eui = require("@elastic/eui");
var _objectPathImmutable = _interopRequireDefault(require("object-path-immutable"));
var _lodash = require("lodash");
var _color_picker_popover = require("../../../components/color_picker_popover");
var _tooltip_icon = require("../../../components/tooltip_icon");
var _i18n = require("../../../../i18n");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const {
  set,
  del
} = _objectPathImmutable.default;
const {
  SeriesStyle: strings
} = _i18n.ArgTypesStrings;
const SimpleTemplate = props => {
  const {
    typeInstance,
    argValue,
    onValueChange,
    resolved: {
      labels
    },
    workpad
  } = props;
  const {
    name
  } = typeInstance;
  const chain = (0, _lodash.get)(argValue, 'chain.0', {});
  const chainArgs = (0, _lodash.get)(chain, 'arguments', {});
  const color = (0, _lodash.get)(chainArgs, 'color.0', '');
  const handleChange = (argName, val) => {
    const fn = val === '' ? del : set;
    const newValue = fn(argValue, `chain.0.arguments.${argName}`, [val]);
    return onValueChange(newValue);
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    alignItems: "center",
    className: "canvasArgSeries__colorPicker"
  }, !color || color.length === 0 ? /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs"
  }, strings.getColorLabel())), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    "aria-label": `${strings.getColorLabel()}: ${strings.getColorValueDefault()}`,
    onClick: () => handleChange('color', '#000000')
  }, strings.getColorValueDefault())))) : /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement("label", {
    htmlFor: "series-style"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs"
  }, strings.getColorLabel()))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    style: {
      fontSize: 0
    }
  }, /*#__PURE__*/_react.default.createElement(_color_picker_popover.ColorPickerPopover, {
    anchorPosition: "leftCenter",
    colors: workpad.colors,
    onChange: val => handleChange('color', val),
    value: color,
    ariaLabel: strings.getColorLabel()
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    iconType: "cross",
    color: "danger",
    onClick: () => handleChange('color', ''),
    "aria-label": strings.getRemoveAriaLabel()
  }))), name !== 'defaultStyle' && (!labels || labels.length === 0) && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_tooltip_icon.TooltipIcon, {
    position: "left",
    icon: _tooltip_icon.IconType.warning,
    content: strings.getNoSeriesTooltip()
  })));
};
exports.SimpleTemplate = SimpleTemplate;
SimpleTemplate.displayName = 'SeriesStyleArgSimpleInput';
SimpleTemplate.propTypes = {
  argValue: _propTypes.default.any.isRequired,
  resolved: _propTypes.default.shape({
    labels: _propTypes.default.array.isRequired
  }).isRequired,
  onValueChange: _propTypes.default.func.isRequired,
  workpad: _propTypes.default.shape({
    colors: _propTypes.default.array.isRequired
  }).isRequired
};