"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ElementWrapper = void 0;
var _propTypes = _interopRequireDefault(require("prop-types"));
var _reactRedux = require("react-redux");
var _reactRecompose = require("react-recompose");
var _reactFastCompare = _interopRequireDefault(require("react-fast-compare"));
var _workpad = require("../../state/selectors/workpad");
var _resolved_arg = require("../../lib/resolved_arg");
var _create_handlers = require("../../lib/create_handlers");
var _element_wrapper = require("./element_wrapper");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function selectorFactory(dispatch) {
  let result = {};
  const createHandlers = (0, _create_handlers.createDispatchedHandlerFactory)(dispatch);
  return (nextState, nextOwnProps) => {
    const {
      element,
      ...restOwnProps
    } = nextOwnProps;
    const {
      transformMatrix,
      width,
      height
    } = element;
    const resolvedArg = (0, _workpad.getResolvedArgs)(nextState, element.id, 'expressionRenderable');
    const selectedPage = (0, _workpad.getSelectedPage)(nextState);

    // build interim props object
    const nextResult = {
      ...restOwnProps,
      // state and state-derived props
      selectedPage,
      state: (0, _resolved_arg.getState)(resolvedArg),
      renderable: (0, _resolved_arg.getValue)(resolvedArg),
      // pass along the handlers creation function
      createHandlers,
      // required parts of the element object
      transformMatrix,
      width,
      height,
      // pass along only the useful parts of the element object
      // so handlers object can be created
      element: {
        id: element.id,
        filter: element.filter,
        expression: element.expression
      }
    };

    // update props only if something actually changed
    if (!(0, _reactFastCompare.default)(result, nextResult)) {
      result = nextResult;
    }
    return result;
  };
}
const ElementWrapper = exports.ElementWrapper = (0, _reactRecompose.compose)((0, _reactRedux.connectAdvanced)(selectorFactory), (0, _reactRecompose.withPropsOnChange)((props, nextProps) => !(0, _reactFastCompare.default)(props.element, nextProps.element), props => {
  const {
    element,
    createHandlers
  } = props;
  const handlers = createHandlers(element);
  // this removes element and createHandlers from passed props
  return {
    handlers
  };
}), (0, _reactRecompose.mapProps)(props => {
  // remove element and createHandlers from props passed to component
  // eslint-disable-next-line no-unused-vars
  const {
    element,
    createHandlers,
    selectedPage,
    ...restProps
  } = props;
  return restProps;
}))(_element_wrapper.ElementWrapper);
ElementWrapper.propTypes = {
  element: _propTypes.default.shape({
    id: _propTypes.default.string.isRequired,
    transformMatrix: _propTypes.default.arrayOf(_propTypes.default.number).isRequired,
    width: _propTypes.default.number.isRequired,
    height: _propTypes.default.number.isRequired,
    // sometimes we get a shape, which lacks an expression
    // so element properties can not be marked as required
    expression: _propTypes.default.string,
    filter: _propTypes.default.string
  }).isRequired
};