/*! Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one or more contributor license agreements.
 * Licensed under the Elastic License 2.0; you may not use this file except in compliance with the Elastic License 2.0. */
(window.apm_bundle_jsonpfunction=window.apm_bundle_jsonpfunction||[]).push([[39],{1321:function(e,a,t){"use strict";t.r(a),t.d(a,"Onboarding",(function(){return Ee}));var n=t(1),r=t.n(n),i=t(18),l=t(12),o=t(88),s=t(78),c=t(0),u=t(35),p=t(186);function d({isBeta:e,guideLink:a}){const t=r.a.createElement(l.EuiBetaBadge,{label:c.i18n.translate("xpack.apm.onboarding.betaLabel",{defaultMessage:"Beta"})}),n=Object(p.a)("/plugins/apm/assets/apm.png"),i=[r.a.createElement(l.EuiImage,{size:"l",allowFullScreen:!0,fullScreenIconColor:"dark",alt:c.i18n.translate("xpack.apm.onboarding.introduction.imageAltDescription",{defaultMessage:"screenshot of primary dashboard."}),url:n})];return r.a.createElement(r.a.Fragment,null,r.a.createElement(l.EuiPageHeader,{iconType:"apmApp",pageTitle:r.a.createElement(r.a.Fragment,null,c.i18n.translate("xpack.apm.onboarding.appName",{defaultMessage:"APM"}),e&&r.a.createElement(r.a.Fragment,null," ",t)),description:r.a.createElement(l.EuiText,null,r.a.createElement(u.FormattedMessage,{id:"xpack.apm.onboarding.specProvider.longDescription",defaultMessage:"Application Performance Monitoring (APM) collects in-depth performance metrics and errors from inside your application. It allows you to monitor the performance of thousands of applications in real time. {learnMoreLink}.",values:{learnMoreLink:r.a.createElement(l.EuiLink,{"data-test-subj":"apmIntroductionLearnMoreLink",href:a,"aria-label":c.i18n.translate("xpack.apm.onboarding.specProvider.learnMoreAriaLabel",{defaultMessage:"Learn more about APM"}),target:"_blank"},c.i18n.translate("xpack.apm.onboarding.specProvider.learnMoreLabel",{defaultMessage:"Learn more"}))}})),rightSideItems:i}))}var m=t(34),g=t(123),E=t(77),y=t(84);function k({agentTabs:e,selectedTab:a}){const t=Object(m.useHistory)(),{euiTheme:n}=Object(l.useEuiTheme)();return r.a.createElement(l.EuiTabs,{style:{padding:`0 ${n.size.l}`}},e.map((e=>r.a.createElement(l.EuiTab,{key:e.id,isSelected:e.id===a,onClick:()=>{return a=e.id,void Object(y.b)(t,{query:{agent:a}});var a}},e.text))))}function f({instructionVariants:e,selectedTab:a}){const t=e.find((e=>e.id===a));return t?r.a.createElement(l.EuiSteps,{titleSize:"xs",steps:t.instructions}):r.a.createElement(r.a.Fragment,null)}function v({instructions:e}){const a=Object(n.useMemo)((()=>e.instructionVariants.map((e=>({id:e.id,text:Object(g.b)(e.id)})))),[e]),{query:{agent:t}}=Object(E.b)("/onboarding"),i=null!=t?t:a[0].id;return r.a.createElement(l.EuiSplitPanel.Outer,null,r.a.createElement(l.EuiSplitPanel.Inner,{color:"subdued",paddingSize:"none"},r.a.createElement(k,{agentTabs:a,selectedTab:i})),r.a.createElement(l.EuiSplitPanel.Inner,{paddingSize:"l"},r.a.createElement(l.EuiTitle,{size:"m"},r.a.createElement("h2",null,e.title)),r.a.createElement(l.EuiSpacer,null),r.a.createElement(f,{instructionVariants:e.instructionVariants,selectedTab:i})))}var h=t(152),S=t.n(h);const A=c.i18n.translate("xpack.apm.onboarding.shared_clients.configure.commands.serviceNameHint",{defaultMessage:"The service name is the primary filter in the APM UI and is used to group errors and trace data together. Allowed characters are a-z, A-Z, 0-9, -, _, and space."}),b=c.i18n.translate("xpack.apm.onboarding.shared_clients.configure.commands.secretTokenHint",{defaultMessage:"Use if APM Server requires a secret token. Both the agent and APM Server must be configured with the same token. This ensures that only your agents can send data to your APM server."}),M=c.i18n.translate("xpack.apm.onboarding.shared_clients.configure.commands.apiKeyHint",{defaultMessage:"Use if APM Server requires an API Key. This is used to ensure that only your agents can send data to your APM server. Agents can use API keys as a replacement of secret token, APM server can have multiple API keys. When both secret token and API key are used, API key has priority and secret token is ignored."}),T=c.i18n.translate("xpack.apm.onboarding.shared_clients.configure.commands.serverUrlHint",{defaultMessage:"Set the custom APM Server URL (default: {defaultApmServerUrl}). The URL must be fully qualified, including protocol (http or https) and port.",values:{defaultApmServerUrl:"http://localhost:8200"}}),K=c.i18n.translate("xpack.apm.onboarding.shared_clients.configure.commands.serviceEnvironmentHint",{defaultMessage:'The name of the environment this service is deployed in, e.g., "production" or "staging". Environments allow you to easily filter data on a global level in the APM UI. It\'s important to be consistent when naming environments across agents.'}),C=e=>({...e&&{secretToken:"elastic.apm.secret_token"},...!e&&{apiKey:"elastic.apm.api_key"},apmServerUrl:"elastic.apm.server_url"}),x=e=>({start:1,highlight:"",annotations:{2:A,3:e?M:b,4:T,5:K}}),L=e=>({...e&&{secretToken:"secretToken"},...!e&&{apiKey:"apiKey"},apmServerUrl:"serverUrl"}),P=`// ${c.i18n.translate("xpack.apm.onboarding.nodeClient.configure.commands.addThisToTheFileTopComment",{defaultMessage:"Add this to the very top of the first file loaded in your app"})}\nvar apm = require('elastic-apm-node').start({\n  // {{serviceNameHint}} ${c.i18n.translate("xpack.apm.onboarding.nodeClient.createConfig.commands.serviceName",{defaultMessage:"Overrides the service name in package.json."})}\n  serviceName: '<your-service-name>',\n\n  {{^secretToken}}\n  // {{apiKeyHint}}\n  apiKey: '{{{apiKey}}}',\n  {{/secretToken}}\n  {{#secretToken}}\n  // {{secretTokenHint}}\n  secretToken: '{{{secretToken}}}',\n  {{/secretToken}}\n\n  // {{{serverUrlHint}}}\n  serverUrl: '{{{apmServerUrl}}}',\n\n  // {{{serviceEnvironmentHint}}}\n  environment: '<your-environment>'\n})`,_=e=>({...e&&{secretToken:"SECRET_TOKEN"},...!e&&{apiKey:"API_KEY"},apmServerUrl:"SERVER_URL"}),w=`INSTALLED_APPS = (\n  # ${c.i18n.translate("xpack.apm.onboarding.djangoClient.configure.commands.addAgentComment",{defaultMessage:"Add the agent to installed apps"})}\n  'elasticapm.contrib.django',\n  # ...\n)\n\nELASTIC_APM = {\n  # {{serviceNameHint}}\n  'SERVICE_NAME': '<your-service-name>',\n\n  {{^secretToken}}\n  # {{apiKeyHint}}\n  'API_KEY': '{{{apiKey}}}',\n  {{/secretToken}}\n  {{#secretToken}}\n  # {{secretTokenHint}}\n  'SECRET_TOKEN': '{{{secretToken}}}',\n  {{/secretToken}}\n\n  # {{{serverUrlHint}}}\n  'SERVER_URL': '{{{apmServerUrl}}}',\n\n  # {{{serviceEnvironmentHint}}}\n  'ENVIRONMENT': '<your-environment>',\n}\n\nMIDDLEWARE = (\n  # ${c.i18n.translate("xpack.apm.onboarding.djangoClient.configure.commands.addTracingMiddlewareComment",{defaultMessage:"Add our tracing middleware to send performance metrics"})}\n  'elasticapm.contrib.django.middleware.TracingMiddleware',\n  #...\n)`,I=e=>({...e&&{secretToken:"SECRET_TOKEN"},...!e&&{apiKey:"API_KEY"},apmServerUrl:"SERVER_URL"}),O=`# ${c.i18n.translate("xpack.apm.onboarding.flaskClient.configure.commands.initializeUsingEnvironmentVariablesComment",{defaultMessage:"Initialize using environment variables"})}\nfrom elasticapm.contrib.flask import ElasticAPM\napp = Flask(__name__)\napm = ElasticAPM(app)\n\n# ${c.i18n.translate("xpack.apm.onboarding.flaskClient.configure.commands.configureElasticApmComment",{defaultMessage:"Or use ELASTIC_APM in your application's settings"})}\nfrom elasticapm.contrib.flask import ElasticAPM\napp.config['ELASTIC_APM'] = {\n  # {{serviceNameHint}}\n  'SERVICE_NAME': '<your-service-name>',\n  {{^secretToken}}\n  # {{apiKeyHint}}\n  'API_KEY': '{{{apiKey}}}',\n  {{/secretToken}}\n  {{#secretToken}}\n  # {{secretTokenHint}}\n  'SECRET_TOKEN': '{{{secretToken}}}',\n  {{/secretToken}}\n\n  # {{{serverUrlHint}}}\n  'SERVER_URL': '{{{apmServerUrl}}}',\n\n  # {{{serviceEnvironmentHint}}}\n  'ENVIRONMENT': '<your-environment>',\n}\n\napm = ElasticAPM(app)`,F=e=>({...e&&{secretToken:"secret_token"},...!e&&{apiKey:"api_key"},apmServerUrl:"server_url"}),U=`# config/elastic_apm.yml:\n\n# {{serviceNameHint}} ${c.i18n.translate("xpack.apm.onboarding.railsClient.createConfig.commands.defaultServiceName",{defaultMessage:"Defaults to the name of your Rails app."})}\nservice_name: '<your-service-name>'\n\n{{^secretToken}}\n# {{apiKeyHint}}\napi_key: '{{{apiKey}}}'\n{{/secretToken}}\n{{#secretToken}}\n# {{secretTokenHint}}\nsecret_token: '{{{secretToken}}}'\n{{/secretToken}}\n\n# {{{serverUrlHint}}}\nserver_url: '{{{apmServerUrl}}}'\n\n# {{{serviceEnvironmentHint}}}\nenvironment: '<your-environment>'`,j=e=>({...e&&{secretToken:"secret_token"},...!e&&{apiKey:"api_key"},apmServerUrl:"server_url"}),N=`# config/elastic_apm.yml:\n\n# {{serviceNameHint}} ${c.i18n.translate("xpack.apm.onboarding.rackClient.createConfig.commands.defaultsToTheNameOfRackAppClassComment",{defaultMessage:"Defaults to the name of your Rack app's class."})}\nservice_name: '<your-service-name>'\n\n{{^secretToken}}\n# {{apiKeyHint}}\napi_key: '{{{apiKey}}}'\n{{/secretToken}}\n{{#secretToken}}\n# {{secretTokenHint}}\nsecret_token: '{{{secretToken}}}'\n{{/secretToken}}\n\n# {{{serverUrlHint}}}\nserver_url: '{{{apmServerUrl}}}'\n\n# {{{serviceEnvironmentHint}}}\nenvironment: '<your-environment>'`,R=e=>({...e&&{secretToken:"ELASTIC_APM_SECRET_TOKEN"},...!e&&{apiKey:"ELASTIC_APM_API_KEY"},apmServerUrl:"ELASTIC_APM_SERVER_URL"}),H=`# ${c.i18n.translate("xpack.apm.onboarding.goClient.configure.commands.initializeUsingEnvironmentVariablesComment",{defaultMessage:"Initialize using environment variables:"})}\n\n# {{serviceNameHint}} ${c.i18n.translate("xpack.apm.onboarding.goClient.configure.commands.usedExecutableNameComment",{defaultMessage:"If not specified, the executable name will be used."})}\nexport ELASTIC_APM_SERVICE_NAME=<your-service-name>\n\n{{^secretToken}}\n# {{apiKeyHint}}\nexport ELASTIC_APM_API_KEY={{{apiKey}}}\n{{/secretToken}}\n{{#secretToken}}\n# {{secretTokenHint}}\nexport ELASTIC_APM_SECRET_TOKEN={{{secretToken}}}\n{{/secretToken}}\n\n# {{{serverUrlHint}}}\nexport ELASTIC_APM_SERVER_URL={{{apmServerUrl}}}\n\n# {{{serviceEnvironmentHint}}}\nexport ELASTIC_APM_ENVIRONMENT=<your-environment>\n`,D=e=>({...e&&{secretToken:"SecretToken"},...!e&&{apiKey:"ApiKey"},apmServerUrl:"ServerUrl"}),B=`{\n  "ElasticApm": {\n    /// {{serviceNameHint}} ${c.i18n.translate("xpack.apm.onboarding.dotnetClient.createConfig.commands.defaultServiceName",{defaultMessage:"Default is the entry assembly of the application."})}\n    "ServiceName": "<your-service-name>",\n    {{^secretToken}}\n    /// {{apiKeyHint}}\n    "ApiKey": "{{{apiKey}}}",\n    {{/secretToken}}\n    {{#secretToken}}\n    /// {{secretTokenHint}}\n    "SecretToken": "{{{secretToken}}}",\n    {{/secretToken}}\n    /// {{{serverUrlHint}}}\n    "ServerUrl": "{{{apmServerUrl}}}",\n    /// {{{serviceEnvironmentHint}}}\n    "Environment": "<your-environment>",\n  }\n}`,$=e=>({...e&&{secretToken:"elastic_apm.secret_token"},...!e&&{apiKey:"elastic_apm.api_key"},apmServerUrl:"elastic_apm.server_url"}),V={java:"java -javaagent:/path/to/elastic-apm-agent-<version>.jar \\\n-Delastic.apm.service_name=<your-service-name> \\\n{{^secretToken}}\n-Delastic.apm.api_key={{{apiKey}}} \\\n{{/secretToken}}\n{{#secretToken}}\n-Delastic.apm.secret_token={{{secretToken}}} \\\n{{/secretToken}}\n-Delastic.apm.server_url={{{apmServerUrl}}} \\\n-Delastic.apm.environment=<your-environment> \\\n-Delastic.apm.application_packages=org.example \\\n-jar my-service-name.jar",node:P,django:w,flask:O,rails:U,rack:N,go:H,dotnet:B,php:'# {{serviceNameHint}}\nelastic_apm.service_name="<your-service-name>"\n\n{{^secretToken}}\n# {{apiKeyHint}}\nelastic_apm.api_key="{{{apiKey}}}"\n{{/secretToken}}\n{{#secretToken}}\n# {{secretTokenHint}}\nelastic_apm.secret_token="{{{secretToken}}}"\n{{/secretToken}}\n\n# {{serverUrlHint}}\nelastic_apm.server_url="{{{apmServerUrl}}}"\n\n# {{{serviceEnvironmentHint}}}\nelastic_apm.environment="<your-environment>"'},z={java:"java",node:"js",django:"py",flask:"py",rails:"rb",rack:"rb",go:"go",dotnet:"dotnet",php:"php"};var G=t(6);function q({columnKey:e,value:a,createApiKey:t,createApiKeyLoading:n}){return"apiKey"===e&&null===a?r.a.createElement(l.EuiButton,{"data-test-subj":"createApiKeyAndId",fill:!0,onClick:t,isLoading:n},c.i18n.translate("xpack.apm.tutorial.apiKey.create",{defaultMessage:"Create API Key"})):r.a.createElement(r.a.Fragment,null,r.a.createElement(l.EuiText,{size:"s",color:"accent"},a),a&&r.a.createElement(l.EuiButtonIcon,{"data-test-subj":"apmConfigurationValueColumnButton","aria-label":c.i18n.translate("xpack.apm.onboarding.column.value.copyIconText",{defaultMessage:"Copy to clipboard"}),color:"text",iconType:"copy",onClick:()=>Object(l.copyToClipboard)(a)}))}function X({variables:e,data:a,createApiKey:t,createApiKeyLoading:n}){if(!e)return null;const i={apmServiceName:"my-service-name",apmEnvironment:"my-environment"},o=[{field:"setting",name:c.i18n.translate("xpack.apm.onboarding.agent.column.configSettings",{defaultMessage:"Configuration setting"})},{field:"value",name:c.i18n.translate("xpack.apm.onboarding.agent.column.configValue",{defaultMessage:"Configuration value"}),render:(e,{value:a,key:i})=>r.a.createElement(q,{columnKey:i,value:a,createApiKey:t,createApiKeyLoading:n})}],s=Object.entries(e).map((([e,t])=>({setting:t,value:Object(G.get)({...a,...i},e),key:e})));return r.a.createElement(l.EuiBasicTable,{items:s,columns:o})}function Y({variantId:e,apmServerUrl:a,secretToken:t,apiKey:n,createApiKey:i,createApiKeyLoading:o}){const s=function({variantId:e,apmServerUrl:a,secretToken:t,apiKey:n}){const r=V[e];return r?S.a.render(r,{apmServerUrl:a,secretToken:t,apiKey:n,serviceNameHint:A,serviceEnvironmentHint:K,serverUrlHint:T,secretTokenHint:b,apiKeyHint:M}):""}({variantId:e,apmServerUrl:a,secretToken:t,apiKey:n}),c=function(e,a){return(e=>({java:C(e),node:L(e),django:_(e),flask:I(e),rails:F(e),rack:j(e),go:R(e),dotnet:D(e),php:$(e)}))(a)[e]}(e,t),u=function(e,a){return(e=>({java:x(e),node:{start:1,highlight:"2, 4, 7, 10, 13-14"},django:{start:1,highlight:"1, 3, 5, 7, 9, 12, 15, 18-19, 21, 23, 25"},flask:{start:1,highlight:"2-4, 7-8, 10, 12, 15, 18-21"},rails:{start:1,highlight:"4, 7, 10, 13"},rack:{start:1,highlight:"4, 7, 10, 13"},go:{start:1,highlight:"4, 7, 10, 13"},dotnet:{start:1,highlight:"1-2, 4, 6, 8, 10-12"},php:{start:1,highlight:"2, 5, 8, 11"}}))(a)[e]}(e,n),p=function(e){return z[e]}(e);return r.a.createElement(r.a.Fragment,null,r.a.createElement(l.EuiSpacer,null),r.a.createElement(X,{variables:c,data:{apmServerUrl:a,secretToken:t,apiKey:n},createApiKey:i,createApiKeyLoading:o}),r.a.createElement(l.EuiSpacer,null),r.a.createElement(l.EuiCodeBlock,{isCopyable:!0,language:p||"bash","data-test-subj":"commands",lineNumbers:u,whiteSpace:"pre"},s))}function W({isSuccess:e,isError:a,errorMessage:t}){return e?r.a.createElement(r.a.Fragment,null,r.a.createElement(l.EuiCallOut,{title:c.i18n.translate("xpack.apm.onboarding.apiKey.success.calloutTitle",{defaultMessage:"API key created"}),color:"success",iconType:"check","data-test-subj":"apiKeySuccessCallout"},c.i18n.translate("xpack.apm.onboarding.apiKey.success.calloutMessage",{defaultMessage:"Remember to store this information in a safe place. It won't be displayed anymore after you continue"}))):a&&/missing the following requested privilege\(s\)/.test(t||"")?r.a.createElement(l.EuiCallOut,{title:c.i18n.translate("xpack.apm.onboarding.apiKey.warning.calloutTitle",{defaultMessage:"User does not have permissions to create API Key"}),color:"warning",iconType:"warning","data-test-subj":"apiKeyWarningCallout"},c.i18n.translate("xpack.apm.onboarding.apiKey.warning.calloutMessage",{defaultMessage:"User is missing the following privilege - {missingPrivilege}. Please add the missing APM application privilege to the role of the authenticated user",values:{missingPrivilege:"event:write"}})):r.a.createElement(l.EuiCallOut,{title:c.i18n.translate("xpack.apm.onboarding.apiKey.error.calloutTitle",{defaultMessage:"Failed to create API key"}),color:"danger",iconType:"error","data-test-subj":"apiKeyErrorCallout"},c.i18n.translate("xpack.apm.onboarding.apiKey.error.calloutMessage",{defaultMessage:"Error: {errorMessage}",values:{errorMessage:t}}))}function J(){return r.a.createElement(l.EuiCallOut,{color:"warning","data-test-subj":"agentStatusWarningCallout"},c.i18n.translate("xpack.apm.onboarding.agentStatus.warning.calloutMessage",{defaultMessage:"No data has been received from agents yet"}))}function Z(){return r.a.createElement(l.EuiCallOut,{color:"success","data-test-subj":"agentStatusSuccessCallout"},c.i18n.translate("xpack.apm.onboarding.agentStatus.success.calloutMessage",{defaultMessage:"Data successfully received from one or more agents"}))}function Q({checkAgentStatus:e,agentStatus:a,agentStatusLoading:t}){let n="incomplete",i=r.a.createElement(r.a.Fragment,null);return!1===a&&(n="warning",i=r.a.createElement(J,null)),a&&(n="complete",i=r.a.createElement(Z,null)),{title:c.i18n.translate("xpack.apm.onboarding.agentStatusCheck.title",{defaultMessage:"Agent status"}),children:r.a.createElement(r.a.Fragment,null,r.a.createElement(l.EuiMarkdownFormat,null,c.i18n.translate("xpack.apm.onboarding.agentStatusCheck.textPre",{defaultMessage:"Make sure your application is running and the agents are sending data."})),r.a.createElement(l.EuiSpacer,null),r.a.createElement(l.EuiButton,{"data-test-subj":"checkAgentStatus",onClick:e,isLoading:t},c.i18n.translate("xpack.apm.onboarding.agentStatus.check",{defaultMessage:"Check Agent Status"})),r.a.createElement(l.EuiSpacer,null),i),status:n}}const ee=e=>{const{baseUrl:a,apmServerUrl:t,apiKeyDetails:n,checkAgentStatus:i,agentStatus:o,agentStatusLoading:s}=e;return[{title:c.i18n.translate("xpack.apm.onboarding.java.download.title",{defaultMessage:"Download the APM agent"}),children:r.a.createElement(l.EuiMarkdownFormat,null,c.i18n.translate("xpack.apm.onboarding.java.download.textPre",{defaultMessage:"Download the agent jar from [Maven Central]({mavenCentralLink}).       Do **not** add the agent as a dependency to your application.",values:{mavenCentralLink:"https://oss.sonatype.org/service/local/artifact/maven/redirect?r=releases&g=co.elastic.apm&a=elastic-apm-agent&v=LATEST"}}))},{title:c.i18n.translate("xpack.apm.onboarding.java.startApplication.title",{defaultMessage:"Start your application with the javaagent flag"}),children:r.a.createElement(r.a.Fragment,null,r.a.createElement(l.EuiMarkdownFormat,null,c.i18n.translate("xpack.apm.onboarding.java.startApplication.textPre",{defaultMessage:"Add the `-javaagent` flag and configure the agent with system properties.\n\n * Set the required service name (allowed characters: a-z, A-Z, 0-9, -, _, and space)\n * Set the custom APM Server URL (default: {customApmServerUrl})\n * Set the APM Server secret token\n * Set the service environment\n * Set the base package of your application",values:{customApmServerUrl:"http://localhost:8200"}})),r.a.createElement(l.EuiSpacer,null),((null==n?void 0:n.displayApiKeySuccessCallout)||(null==n?void 0:n.displayApiKeyErrorCallout))&&r.a.createElement(r.a.Fragment,null,r.a.createElement(W,{isError:null==n?void 0:n.displayApiKeyErrorCallout,isSuccess:null==n?void 0:n.displayApiKeySuccessCallout,errorMessage:null==n?void 0:n.errorMessage}),r.a.createElement(l.EuiSpacer,null)),r.a.createElement(Y,{variantId:g.a.JAVA,apmServerUrl:t,apiKey:null==n?void 0:n.apiKey,createApiKey:null==n?void 0:n.createAgentKey,createApiKeyLoading:null==n?void 0:n.createApiKeyLoading}),r.a.createElement(l.EuiSpacer,null),r.a.createElement(l.EuiMarkdownFormat,null,c.i18n.translate("xpack.apm.onboarding.java.startApplication.textPost",{defaultMessage:"See the [documentation]({documentationLink}) for configuration options and advanced         usage.",values:{documentationLink:`${a}guide/en/apm/agent/java/current/index.html`}})))},Q({checkAgentStatus:i,agentStatus:o,agentStatusLoading:s})]},ae=e=>{const{baseUrl:a,apmServerUrl:t,apiKeyDetails:n,checkAgentStatus:i,agentStatus:o,agentStatusLoading:s}=e;return[{title:c.i18n.translate("xpack.apm.onboarding.node.install.title",{defaultMessage:"Install the APM agent"}),children:r.a.createElement(r.a.Fragment,null,r.a.createElement(l.EuiMarkdownFormat,null,c.i18n.translate("xpack.apm.onboarding.node.install.textPre",{defaultMessage:"Install the APM agent for Node.js as a dependency to your application."})),r.a.createElement(l.EuiSpacer,null),r.a.createElement(l.EuiCodeBlock,{language:"bash",isCopyable:!0},"npm install elastic-apm-node --save"))},{title:c.i18n.translate("xpack.apm.onboarding.node.configure.title",{defaultMessage:"Configure the agent"}),children:r.a.createElement(r.a.Fragment,null,r.a.createElement(l.EuiMarkdownFormat,null,c.i18n.translate("xpack.apm.onboarding.node.configure.textPre",{defaultMessage:"Agents are libraries that run inside of your application process.  APM services are created programmatically based on the `serviceName`.  This agent supports a variety of frameworks but can also be used with your custom stack."})),r.a.createElement(l.EuiSpacer,null),((null==n?void 0:n.displayApiKeySuccessCallout)||(null==n?void 0:n.displayApiKeyErrorCallout))&&r.a.createElement(r.a.Fragment,null,r.a.createElement(W,{isError:null==n?void 0:n.displayApiKeyErrorCallout,isSuccess:null==n?void 0:n.displayApiKeySuccessCallout,errorMessage:null==n?void 0:n.errorMessage}),r.a.createElement(l.EuiSpacer,null)),r.a.createElement(Y,{variantId:g.a.NODE,apmServerUrl:t,apiKey:null==n?void 0:n.apiKey,createApiKey:null==n?void 0:n.createAgentKey,createApiKeyLoading:null==n?void 0:n.createApiKeyLoading}),r.a.createElement(l.EuiSpacer,null),r.a.createElement(l.EuiMarkdownFormat,null,c.i18n.translate("xpack.apm.onboarding.node.configure.textPost",{defaultMessage:"See [the documentation]({documentationLink}) for advanced usage, including how to use with [Babel/ES Modules]({babelEsModulesLink}).",values:{documentationLink:`${a}guide/en/apm/agent/nodejs/current/index.html`,babelEsModulesLink:`${a}guide/en/apm/agent/nodejs/current/advanced-setup.html#es-modules`}})))},Q({checkAgentStatus:i,agentStatus:o,agentStatusLoading:s})]},te=e=>{const{baseUrl:a,apmServerUrl:t,apiKeyDetails:n,checkAgentStatus:i,agentStatus:o,agentStatusLoading:s}=e;return[{title:c.i18n.translate("xpack.apm.onboarding.django.install.title",{defaultMessage:"Install the APM agent"}),children:r.a.createElement(r.a.Fragment,null,r.a.createElement(l.EuiMarkdownFormat,null,c.i18n.translate("xpack.apm.onboarding.django.install.textPre",{defaultMessage:"Install the APM agent for Python as a dependency."})),r.a.createElement(l.EuiSpacer,null),r.a.createElement(l.EuiCodeBlock,{language:"bash",isCopyable:!0},"$ pip install elastic-apm"))},{title:c.i18n.translate("xpack.apm.onboarding.django.configure.title",{defaultMessage:"Configure the agent"}),children:r.a.createElement(r.a.Fragment,null,r.a.createElement(l.EuiMarkdownFormat,null,c.i18n.translate("xpack.apm.onboarding.django.configure.textPre",{defaultMessage:"Agents are libraries that run inside of your application process. APM services are created programmatically based on the `SERVICE_NAME`."})),r.a.createElement(l.EuiSpacer,null),((null==n?void 0:n.displayApiKeySuccessCallout)||(null==n?void 0:n.displayApiKeyErrorCallout))&&r.a.createElement(r.a.Fragment,null,r.a.createElement(W,{isError:null==n?void 0:n.displayApiKeyErrorCallout,isSuccess:null==n?void 0:n.displayApiKeySuccessCallout,errorMessage:null==n?void 0:n.errorMessage}),r.a.createElement(l.EuiSpacer,null)),r.a.createElement(Y,{variantId:g.a.DJANGO,apmServerUrl:t,apiKey:null==n?void 0:n.apiKey,createApiKey:null==n?void 0:n.createAgentKey,createApiKeyLoading:null==n?void 0:n.createApiKeyLoading}),r.a.createElement(l.EuiSpacer,null),r.a.createElement(l.EuiMarkdownFormat,null,c.i18n.translate("xpack.apm.onboarding.django.configure.textPost",{defaultMessage:"See the [documentation]({documentationLink}) for advanced usage.",values:{documentationLink:`${a}guide/en/apm/agent/python/current/django-support.html`}})))},Q({checkAgentStatus:i,agentStatus:o,agentStatusLoading:s})]},ne=e=>{const{baseUrl:a,apmServerUrl:t,apiKeyDetails:n,checkAgentStatus:i,agentStatus:o,agentStatusLoading:s}=e;return[{title:c.i18n.translate("xpack.apm.onboarding.flask.install.title",{defaultMessage:"Install the APM agent"}),children:r.a.createElement(r.a.Fragment,null,r.a.createElement(l.EuiMarkdownFormat,null,c.i18n.translate("xpack.apm.onboarding.flask.install.textPre",{defaultMessage:"Install the APM agent for Python as a dependency."})),r.a.createElement(l.EuiSpacer,null),r.a.createElement(l.EuiCodeBlock,{language:"bash",isCopyable:!0},"$ pip install elastic-apm[flask]"))},{title:c.i18n.translate("xpack.apm.onboarding.flask.configure.title",{defaultMessage:"Configure the agent"}),children:r.a.createElement(r.a.Fragment,null,r.a.createElement(l.EuiMarkdownFormat,null,c.i18n.translate("xpack.apm.onboarding.flask.configure.textPre",{defaultMessage:"Agents are libraries that run inside of your application process. APM services are created programmatically based on the `SERVICE_NAME`."})),r.a.createElement(l.EuiSpacer,null),((null==n?void 0:n.displayApiKeySuccessCallout)||(null==n?void 0:n.displayApiKeyErrorCallout))&&r.a.createElement(r.a.Fragment,null,r.a.createElement(W,{isError:null==n?void 0:n.displayApiKeyErrorCallout,isSuccess:null==n?void 0:n.displayApiKeySuccessCallout,errorMessage:null==n?void 0:n.errorMessage}),r.a.createElement(l.EuiSpacer,null)),r.a.createElement(Y,{variantId:g.a.FLASK,apmServerUrl:t,apiKey:null==n?void 0:n.apiKey,createApiKey:null==n?void 0:n.createAgentKey,createApiKeyLoading:null==n?void 0:n.createApiKeyLoading}),r.a.createElement(l.EuiSpacer,null),r.a.createElement(l.EuiMarkdownFormat,null,c.i18n.translate("xpack.apm.onboarding.flask.configure.textPost",{defaultMessage:"See the [documentation]({documentationLink}) for advanced usage.",values:{documentationLink:`${a}guide/en/apm/agent/python/current/flask-support.html`}})))},Q({checkAgentStatus:i,agentStatus:o,agentStatusLoading:s})]},re=e=>{const{baseUrl:a,apmServerUrl:t,apiKeyDetails:n,checkAgentStatus:i,agentStatus:o,agentStatusLoading:s}=e;return[{title:c.i18n.translate("xpack.apm.onboarding.rails.install.title",{defaultMessage:"Install the APM agent"}),children:r.a.createElement(r.a.Fragment,null,r.a.createElement(l.EuiMarkdownFormat,null,c.i18n.translate("xpack.apm.onboarding.rails.install.textPre",{defaultMessage:"Add the agent to your Gemfile."})),r.a.createElement(l.EuiSpacer,null),r.a.createElement(l.EuiCodeBlock,{language:"bash",isCopyable:!0},"gem 'elastic-apm'"))},{title:c.i18n.translate("xpack.apm.onboarding.rails.configure.title",{defaultMessage:"Configure the agent"}),children:r.a.createElement(r.a.Fragment,null,r.a.createElement(l.EuiMarkdownFormat,null,c.i18n.translate("xpack.apm.onboarding.rails.configure.textPre",{defaultMessage:"APM is automatically started when your app boots. Configure the agent, by creating the config file {configFile}",values:{configFile:"`config/elastic_apm.yml`"}})),r.a.createElement(l.EuiSpacer,null),((null==n?void 0:n.displayApiKeySuccessCallout)||(null==n?void 0:n.displayApiKeyErrorCallout))&&r.a.createElement(r.a.Fragment,null,r.a.createElement(W,{isError:null==n?void 0:n.displayApiKeyErrorCallout,isSuccess:null==n?void 0:n.displayApiKeySuccessCallout,errorMessage:null==n?void 0:n.errorMessage}),r.a.createElement(l.EuiSpacer,null)),r.a.createElement(Y,{variantId:g.a.RAILS,apmServerUrl:t,apiKey:null==n?void 0:n.apiKey,createApiKey:null==n?void 0:n.createAgentKey,createApiKeyLoading:null==n?void 0:n.createApiKeyLoading}),r.a.createElement(l.EuiSpacer,null),r.a.createElement(l.EuiMarkdownFormat,null,c.i18n.translate("xpack.apm.onboarding.rails.configure.textPost",{defaultMessage:"See the [documentation]({documentationLink}) for configuration options and advanced usage.\n\n",values:{documentationLink:`${a}guide/en/apm/agent/ruby/current/index.html`}})))},Q({checkAgentStatus:i,agentStatus:o,agentStatusLoading:s})]},ie=e=>{const{baseUrl:a,apmServerUrl:t,apiKeyDetails:n,checkAgentStatus:i,agentStatus:o,agentStatusLoading:s}=e,u=`# config.ru\n  require 'sinatra/base'\n\n  class MySinatraApp < Sinatra::Base\n    use ElasticAPM::Middleware\n\n    # ...\n  end\n\n  ElasticAPM.start(\n    app: MySinatraApp, # ${c.i18n.translate("xpack.apm.onboarding.rack.configure.commands.requiredComment",{defaultMessage:"required"})}\n    config_file: '' # ${c.i18n.translate("xpack.apm.onboarding.rack.configure.commands.optionalComment",{defaultMessage:"optional, defaults to config/elastic_apm.yml"})}\n  )\n\n  run MySinatraApp\n\n  at_exit { ElasticAPM.stop }`;return[{title:c.i18n.translate("xpack.apm.onboarding.rack.install.title",{defaultMessage:"Install the APM agent"}),children:r.a.createElement(r.a.Fragment,null,r.a.createElement(l.EuiMarkdownFormat,null,c.i18n.translate("xpack.apm.onboarding.rack.install.textPre",{defaultMessage:"Add the agent to your Gemfile."})),r.a.createElement(l.EuiSpacer,null),r.a.createElement(l.EuiCodeBlock,{language:"bash",isCopyable:!0},"gem 'elastic-apm'"))},{title:c.i18n.translate("xpack.apm.onboarding.rack.configure.title",{defaultMessage:"Configure the agent"}),children:r.a.createElement(r.a.Fragment,null,r.a.createElement(l.EuiMarkdownFormat,null,c.i18n.translate("xpack.apm.onboarding.rack.configure.textPre",{defaultMessage:"For Rack or a compatible framework (e.g. Sinatra), include the middleware in your app and start the agent."})),r.a.createElement(l.EuiSpacer,null),r.a.createElement(l.EuiCodeBlock,{language:"bash",isCopyable:!0},u))},{title:c.i18n.translate("xpack.apm.onboarding.rack.createConfig.title",{defaultMessage:"Create config file"}),children:r.a.createElement(r.a.Fragment,null,r.a.createElement(l.EuiMarkdownFormat,null,c.i18n.translate("xpack.apm.onboarding.rack.createConfig.textPre",{defaultMessage:"Create a config file {configFile}:",values:{configFile:"`config/elastic_apm.yml`"}})),r.a.createElement(l.EuiSpacer,null),((null==n?void 0:n.displayApiKeySuccessCallout)||(null==n?void 0:n.displayApiKeyErrorCallout))&&r.a.createElement(r.a.Fragment,null,r.a.createElement(W,{isError:null==n?void 0:n.displayApiKeyErrorCallout,isSuccess:null==n?void 0:n.displayApiKeySuccessCallout,errorMessage:null==n?void 0:n.errorMessage}),r.a.createElement(l.EuiSpacer,null)),r.a.createElement(Y,{variantId:g.a.RACK,apmServerUrl:t,apiKey:null==n?void 0:n.apiKey,createApiKey:null==n?void 0:n.createAgentKey,createApiKeyLoading:null==n?void 0:n.createApiKeyLoading}),r.a.createElement(l.EuiSpacer,null),r.a.createElement(l.EuiMarkdownFormat,null,c.i18n.translate("xpack.apm.onboarding.rack.configure.textPost",{defaultMessage:"See the [documentation]({documentationLink}) for configuration options and advanced usage.\n\n",values:{documentationLink:`${a}guide/en/apm/agent/ruby/current/index.html`}})))},Q({checkAgentStatus:i,agentStatus:o,agentStatusLoading:s})]},le=e=>{const{baseUrl:a,apmServerUrl:t,apiKeyDetails:n,checkAgentStatus:i,agentStatus:o,agentStatusLoading:s}=e;return[{title:c.i18n.translate("xpack.apm.onboarding.go.install.title",{defaultMessage:"Install the APM agent"}),children:r.a.createElement(r.a.Fragment,null,r.a.createElement(l.EuiMarkdownFormat,null,c.i18n.translate("xpack.apm.onboarding.go.install.textPre",{defaultMessage:"Install the APM agent packages for Go."})),r.a.createElement(l.EuiSpacer,null),r.a.createElement(l.EuiCodeBlock,{language:"bash",isCopyable:!0},"go get go.elastic.co/apm"))},{title:c.i18n.translate("xpack.apm.onboarding.go.configure.title",{defaultMessage:"Configure the agent"}),children:r.a.createElement(r.a.Fragment,null,r.a.createElement(l.EuiMarkdownFormat,null,c.i18n.translate("xpack.apm.onboarding.go.configure.textPre",{defaultMessage:"Agents are libraries that run inside of your application process. APM services are created programmatically based on the executable file name, or the `ELASTIC_APM_SERVICE_NAME` environment variable."})),r.a.createElement(l.EuiSpacer,null),((null==n?void 0:n.displayApiKeySuccessCallout)||(null==n?void 0:n.displayApiKeyErrorCallout))&&r.a.createElement(r.a.Fragment,null,r.a.createElement(W,{isError:null==n?void 0:n.displayApiKeyErrorCallout,isSuccess:null==n?void 0:n.displayApiKeySuccessCallout,errorMessage:null==n?void 0:n.errorMessage}),r.a.createElement(l.EuiSpacer,null)),r.a.createElement(Y,{variantId:g.a.GO,apmServerUrl:t,apiKey:null==n?void 0:n.apiKey,createApiKey:null==n?void 0:n.createAgentKey,createApiKeyLoading:null==n?void 0:n.createApiKeyLoading}),r.a.createElement(l.EuiSpacer,null),r.a.createElement(l.EuiMarkdownFormat,null,c.i18n.translate("xpack.apm.onboarding.go.configure.textPost",{defaultMessage:"See the [documentation]({documentationLink}) for advanced configuration.",values:{documentationLink:`${a}guide/en/apm/agent/go/current/configuration.html`}})))},{title:c.i18n.translate("xpack.apm.onboarding.go.goClient.title",{defaultMessage:"Instrument your application"}),children:r.a.createElement(r.a.Fragment,null,r.a.createElement(l.EuiMarkdownFormat,null,c.i18n.translate("xpack.apm.onboarding.go.instrument.textPre",{defaultMessage:"Instrument your Go application by using one of the provided instrumentation modules or by using the tracer API directly."})),r.a.createElement(l.EuiSpacer,null),r.a.createElement(l.EuiCodeBlock,{language:"go",isCopyable:!0},'import (\n  "net/http"\n\n  "go.elastic.co/apm/module/apmhttp"\n)\n\nfunc main() {\n  mux := http.NewServeMux()\n  ...\n  http.ListenAndServe(":8080", apmhttp.Wrap(mux))\n}\n'),r.a.createElement(l.EuiMarkdownFormat,null,c.i18n.translate("xpack.apm.onboarding.go.instrument.textPost",{defaultMessage:"See the [documentation]({documentationLink}) for a detailed guide to instrumenting Go source code.",values:{documentationLink:`${a}guide/en/apm/agent/go/current/instrumenting-source.html`}})))},Q({checkAgentStatus:i,agentStatus:o,agentStatusLoading:s})]},oe=e=>{const{baseUrl:a,apmServerUrl:t,apiKeyDetails:n,checkAgentStatus:i,agentStatus:o,agentStatusLoading:s}=e;return[{title:c.i18n.translate("xpack.apm.onboarding.dotNet.download.title",{defaultMessage:"Download the APM agent"}),children:r.a.createElement(r.a.Fragment,null,r.a.createElement(l.EuiMarkdownFormat,null,c.i18n.translate("xpack.apm.onboarding.dotNet.download.textPre",{defaultMessage:"Add the the agent package(s) from [NuGet]({allNuGetPackagesLink}) to your .NET application. There are multiple       NuGet packages available for different use cases. \n\nFor an ASP.NET Core application with Entity Framework       Core download the [Elastic.Apm.NetCoreAll]({netCoreAllApmPackageLink}) package. This package will automatically add every       agent component to your application. \n\n In case you would like to minimize the dependencies, you can use the       [Elastic.Apm.AspNetCore]({aspNetCorePackageLink}) package for just       ASP.NET Core monitoring or the [Elastic.Apm.EfCore]({efCorePackageLink}) package for just Entity Framework Core monitoring. \n\n In       case you only want to use the public Agent API for manual instrumentation use the [Elastic.Apm]({elasticApmPackageLink}) package.",values:{allNuGetPackagesLink:"https://www.nuget.org/packages?q=Elastic.apm",netCoreAllApmPackageLink:"https://www.nuget.org/packages/Elastic.Apm.NetCoreAll",aspNetCorePackageLink:"https://www.nuget.org/packages/Elastic.Apm.AspNetCore",efCorePackageLink:"https://www.nuget.org/packages/Elastic.Apm.EntityFrameworkCore",elasticApmPackageLink:"https://www.nuget.org/packages/Elastic.Apm"}})))},{title:c.i18n.translate("xpack.apm.onboarding.dotNet.configureApplication.title",{defaultMessage:"Add the agent to the application"}),children:r.a.createElement(r.a.Fragment,null,r.a.createElement(l.EuiMarkdownFormat,null,c.i18n.translate("xpack.apm.onboarding.dotNet.configureApplication.textPre",{defaultMessage:"In case of ASP.NET Core with the `Elastic.Apm.NetCoreAll` package, call the `UseAllElasticApm`       method in the `Configure` method within the `Startup.cs` file."})),r.a.createElement(l.EuiSpacer,null),r.a.createElement(l.EuiCodeBlock,{language:"bash",isCopyable:!0},"public class Startup\n{\n  public void Configure(IApplicationBuilder app, IHostingEnvironment env)\n  {\n    app.UseAllElasticApm(Configuration);\n    //…rest of the method\n  }\n  //…rest of the class\n}"),r.a.createElement(l.EuiSpacer,null),r.a.createElement(l.EuiMarkdownFormat,null,c.i18n.translate("xpack.apm.onboarding.dotNet.configureApplication.textPost",{defaultMessage:"Passing an `IConfiguration` instance is optional and by doing so, the agent will read config settings through this       `IConfiguration` instance (e.g. from the `appsettings.json` file)."})))},{title:c.i18n.translate("xpack.apm.onboarding.dotNet.configureAgent.title",{defaultMessage:"Sample appsettings.json file:"}),children:r.a.createElement(r.a.Fragment,null,((null==n?void 0:n.displayApiKeySuccessCallout)||(null==n?void 0:n.displayApiKeyErrorCallout))&&r.a.createElement(r.a.Fragment,null,r.a.createElement(W,{isError:null==n?void 0:n.displayApiKeyErrorCallout,isSuccess:null==n?void 0:n.displayApiKeySuccessCallout,errorMessage:null==n?void 0:n.errorMessage}),r.a.createElement(l.EuiSpacer,null)),r.a.createElement(Y,{variantId:g.a.DOTNET,apmServerUrl:t,apiKey:null==n?void 0:n.apiKey,createApiKey:null==n?void 0:n.createAgentKey,createApiKeyLoading:null==n?void 0:n.createApiKeyLoading}),r.a.createElement(l.EuiSpacer,null),r.a.createElement(l.EuiMarkdownFormat,null,c.i18n.translate("xpack.apm.onboarding.dotNet.configureAgent.textPost",{defaultMessage:"In case you don’t pass an `IConfiguration` instance to the agent (e.g. in case of non ASP.NET Core applications)       you can also configure the agent through environment variables. \n       See [the documentation]({documentationLink}) for advanced usage, including the [Profiler Auto instrumentation]({profilerLink}) quick start.",values:{documentationLink:`${a}guide/en/apm/agent/dotnet/current/configuration.html`,profilerLink:`${a}guide/en/apm/agent/dotnet/current/setup-auto-instrumentation.html#setup-auto-instrumentation`}})))},Q({checkAgentStatus:i,agentStatus:o,agentStatusLoading:s})]},se=e=>{const{baseUrl:a,apmServerUrl:t,apiKeyDetails:n,checkAgentStatus:i,agentStatus:o,agentStatusLoading:s}=e;return[{title:c.i18n.translate("xpack.apm.onboarding.php.download.title",{defaultMessage:"Download the APM agent"}),children:r.a.createElement(l.EuiMarkdownFormat,null,c.i18n.translate("xpack.apm.onboarding.php.download.textPre",{defaultMessage:"Download the package corresponding to your platform from [GitHub releases]({githubReleasesLink}).",values:{githubReleasesLink:"https://github.com/elastic/apm-agent-php/releases"}}))},{title:c.i18n.translate("xpack.apm.onboarding.php.installPackage.title",{defaultMessage:"Install the downloaded package"}),children:r.a.createElement(r.a.Fragment,null,r.a.createElement(l.EuiMarkdownFormat,null,c.i18n.translate("xpack.apm.onboarding.php.installPackage.textPre",{defaultMessage:"For example on Alpine Linux using APK package:"})),r.a.createElement(l.EuiSpacer,null),r.a.createElement(l.EuiCodeBlock,{language:"bash",isCopyable:!0},"apk add --allow-untrusted <package-file>.apk"),r.a.createElement(l.EuiSpacer,null),r.a.createElement(l.EuiMarkdownFormat,null,c.i18n.translate("xpack.apm.onboarding.php.installPackage.textPost",{defaultMessage:"See the [documentation]({documentationLink}) for installation commands on other supported platforms and advanced installation.",values:{documentationLink:`${a}guide/en/apm/agent/php/current/setup.html`}})))},{title:c.i18n.translate("xpack.apm.onboarding.php.configureAgent.title",{defaultMessage:"Configure the agent"}),children:r.a.createElement(r.a.Fragment,null,r.a.createElement(l.EuiMarkdownFormat,null,c.i18n.translate("xpack.apm.onboarding.php.Configure the agent.textPre",{defaultMessage:"APM is automatically started when your app boots. Configure the agent either via `php.ini` file:"})),((null==n?void 0:n.displayApiKeySuccessCallout)||(null==n?void 0:n.displayApiKeyErrorCallout))&&r.a.createElement(r.a.Fragment,null,r.a.createElement(W,{isError:null==n?void 0:n.displayApiKeyErrorCallout,isSuccess:null==n?void 0:n.displayApiKeySuccessCallout,errorMessage:null==n?void 0:n.errorMessage}),r.a.createElement(l.EuiSpacer,null)),r.a.createElement(Y,{variantId:g.a.PHP,apmServerUrl:t,apiKey:null==n?void 0:n.apiKey,createApiKey:null==n?void 0:n.createAgentKey,createApiKeyLoading:null==n?void 0:n.createApiKeyLoading}),r.a.createElement(l.EuiSpacer,null),r.a.createElement(l.EuiMarkdownFormat,null,c.i18n.translate("xpack.apm.onboarding.php.configureAgent.textPost",{defaultMessage:"See the [documentation]({documentationLink}) for configuration options and advanced usage.\n\n",values:{documentationLink:`${a}guide/en/apm/agent/php/current/configuration.html`}})))},Q({checkAgentStatus:i,agentStatus:o,agentStatusLoading:s})]},ce=e=>{const{baseUrl:a,apmServerUrl:t,apiKeyDetails:n,checkAgentStatus:i,agentStatus:o,agentStatusLoading:s}=e;return[{title:c.i18n.translate("xpack.apm.onboarding.otel.download.title",{defaultMessage:"Download the OpenTelemetry APM Agent or SDK"}),children:r.a.createElement(l.EuiMarkdownFormat,null,c.i18n.translate("xpack.apm.onboarding.otel.download.textPre",{defaultMessage:"See the [OpenTelemetry Instrumentation guides]({openTelemetryInstrumentationLink}) to download the OpenTelemetry Agent or SDK for your language.",values:{openTelemetryInstrumentationLink:"https://opentelemetry.io/docs/instrumentation"}}))},{title:c.i18n.translate("xpack.apm.onboarding.otel.configureAgent.title",{defaultMessage:"Configure OpenTelemetry in your application"}),children:r.a.createElement(r.a.Fragment,null,r.a.createElement(l.EuiMarkdownFormat,null,c.i18n.translate("xpack.apm.onboarding.otel.configureAgent.textPre",{defaultMessage:"Specify the following OpenTelemetry settings as part of the startup of your application. Note that OpenTelemetry SDKs require some bootstrap code in addition to these configuration settings. For more details, see the [Elastic OpenTelemetry documentation]({openTelemetryDocumentationLink}) and the [OpenTelemetry community instrumentation guides]({openTelemetryInstrumentationLink}).",values:{openTelemetryDocumentationLink:`${a}guide/en/apm/guide/current/open-telemetry.html`,openTelemetryInstrumentationLink:"https://opentelemetry.io/docs/instrumentation"}})),r.a.createElement(l.EuiSpacer,null),((null==n?void 0:n.displayApiKeySuccessCallout)||(null==n?void 0:n.displayApiKeyErrorCallout))&&r.a.createElement(r.a.Fragment,null,r.a.createElement(W,{isError:null==n?void 0:n.displayApiKeyErrorCallout,isSuccess:null==n?void 0:n.displayApiKeySuccessCallout,errorMessage:null==n?void 0:n.errorMessage}),r.a.createElement(l.EuiSpacer,null)),r.a.createElement(pe,{apmServerUrl:t,apiKeyDetails:n}),r.a.createElement(l.EuiSpacer,null),r.a.createElement(l.EuiMarkdownFormat,null,c.i18n.translate("xpack.apm.onboarding.otel.configureAgent.textPost",{defaultMessage:"See the [documentation]({documentationLink}) for configuration options and advanced usage.\n\n",values:{documentationLink:`${a}guide/en/apm/guide/current/open-telemetry.html`}})))},Q({checkAgentStatus:i,agentStatus:o,agentStatusLoading:s})]};function ue({setting:e,value:a,createApiKey:t,createApiKeyLoading:n,apiKey:i}){return"OTEL_EXPORTER_OTLP_HEADERS"===e&&null===i?r.a.createElement(l.EuiButton,{"data-test-subj":"createApiKeyAndId",fill:!0,onClick:t,isLoading:n},c.i18n.translate("xpack.apm.onboarding.apiKey.create",{defaultMessage:"Create API Key"})):r.a.createElement(r.a.Fragment,null,r.a.createElement(l.EuiText,{size:"s",color:"accent"},a),a&&r.a.createElement(l.EuiButtonIcon,{"data-test-subj":"apmConfigurationValueColumnButton","aria-label":c.i18n.translate("xpack.apm.onboarding.otel.column.value.copyIconText",{defaultMessage:"Copy to clipboard"}),color:"text",iconType:"copy",onClick:()=>Object(l.copyToClipboard)(a)}))}function pe({apmServerUrl:e,secretToken:a,apiKeyDetails:t}){let n;n=a?`Authorization=Bearer ${a}`:`Authorization=ApiKey ${null==t?void 0:t.apiKey}`;const i=[{setting:"OTEL_EXPORTER_OTLP_ENDPOINT",value:e||"<apm-server-url>"},{setting:"OTEL_EXPORTER_OTLP_HEADERS",value:n,apiKey:null==t?void 0:t.apiKey},{setting:"OTEL_METRICS_EXPORTER",value:"otlp",notes:"Enable metrics when supported by your OpenTelemetry client."},{setting:"OTEL_LOGS_EXPORTER",value:"otlp",notes:"Enable logs when supported by your OpenTelemetry client"},{setting:"OTEL_RESOURCE_ATTRIBUTES",value:"service.name=<app-name>,service.version=<app-version>,deployment.environment=production"}],o=[{field:"setting",width:"23%",name:c.i18n.translate("xpack.apm.onboarding.config_otel.column.configSettings",{defaultMessage:"Configuration setting (1)"})},{field:"value",width:"55%",name:c.i18n.translate("xpack.apm.onboarding.config_otel.column.configValue",{defaultMessage:"Configuration value"}),render:(e,{value:a,setting:n,apiKey:i})=>r.a.createElement(ue,{setting:n,value:a,createApiKey:null==t?void 0:t.createAgentKey,createApiKeyLoading:null==t?void 0:t.createApiKeyLoading,apiKey:null==t?void 0:t.apiKey})},{field:"notes",name:c.i18n.translate("xpack.apm.onboarding.config_otel.column.notes",{defaultMessage:"Notes"})}];return r.a.createElement(r.a.Fragment,null,r.a.createElement(l.EuiBasicTable,{items:i,columns:o,"data-test-subj":"otel-instructions-table"}),r.a.createElement(l.EuiSpacer,{size:"m"}),r.a.createElement(l.EuiText,{size:"xs",color:"subdued"},r.a.createElement(u.FormattedMessage,{id:"xpack.apm.onboarding.config_otel.description1",defaultMessage:"(1) OpenTelemetry agents and SDKs must support the {otelExporterOtlpEndpoint}, {otelExporterOtlpHeaders}, and {otelResourceAttributes} variables; some unstable components may not yet comply with this requirement.",values:{otelExporterOtlpEndpoint:r.a.createElement(l.EuiLink,{"data-test-subj":"apmOpenTelemetryInstructionsOtelExporterOtlpEndpointLink",target:"_blank",href:"https://github.com/open-telemetry/opentelemetry-specification/blob/v1.10.0/specification/protocol/exporter.md"},"OTEL_EXPORTER_OTLP_ENDPOINT"),otelExporterOtlpHeaders:r.a.createElement(l.EuiLink,{"data-test-subj":"apmOpenTelemetryInstructionsOtelExporterOtlpHeadersLink",target:"_blank",href:"https://github.com/open-telemetry/opentelemetry-specification/blob/v1.10.0/specification/protocol/exporter.md"},"OTEL_EXPORTER_OTLP_HEADERS"),otelResourceAttributes:r.a.createElement(l.EuiLink,{"data-test-subj":"apmOpenTelemetryInstructionsOtelResourceAttributesLink",target:"_blank",href:"https://github.com/open-telemetry/opentelemetry-specification/blob/v1.10.0/specification/resource/sdk.md"},"OTEL_RESOURCE_ATTRIBUTES")}}),r.a.createElement(l.EuiSpacer,{size:"xs"}),r.a.createElement(u.FormattedMessage,{id:"xpack.apm.onboarding.config_otel.description2",defaultMessage:"The 'OTEL_METRICS_EXPORTER` and 'OTEL_LOGS_EXPORTER' environment variables may not be supported by some SDKs."}),r.a.createElement(l.EuiSpacer,{size:"xs"}),r.a.createElement(u.FormattedMessage,{id:"xpack.apm.onboarding.config_otel.description3",defaultMessage:"The exhaustive list of environment variables, command line parameters, and configuration code snippets (according to the OpenTelemetry specification) is available in the {otelInstrumentationGuide}. Some unstable OpenTelemetry clients may not support all features and may require alternate configuration mechanisms.",values:{otelInstrumentationGuide:r.a.createElement(l.EuiLink,{"data-test-subj":"apmOpenTelemetryInstructionsOpenTelemetryInstrumentationGuideLink",target:"_blank",href:"https://opentelemetry.io/docs/instrumentation"},c.i18n.translate("xpack.apm.onboarding.config_otel.instrumentationGuide",{defaultMessage:"OpenTelemetry Instrumentation guide"}))}})))}function de({baseUrl:e,config:a,checkAgentStatus:t,agentStatus:n,agentStatusLoading:r},i,l,o){const{apiKey:s,error:u,errorMessage:p}=l,d=Boolean(s)&&!u,m=u&&Boolean(p),E={baseUrl:e,apmServerUrl:`${a.managedServiceUrl}:443`,checkAgentStatus:t,agentStatus:n,agentStatusLoading:r,apiKeyDetails:{...l,displayApiKeySuccessCallout:d,displayApiKeyErrorCallout:m,createAgentKey:o,createApiKeyLoading:i}};return{title:c.i18n.translate("xpack.apm.tutorial.apmAgents.title",{defaultMessage:"APM Agents"}),instructionVariants:[{id:g.a.NODE,instructions:ae(E)},{id:g.a.DJANGO,instructions:te(E)},{id:g.a.FLASK,instructions:ne(E)},{id:g.a.RAILS,instructions:re(E)},{id:g.a.RACK,instructions:ie(E)},{id:g.a.GO,instructions:le(E)},{id:g.a.JAVA,instructions:ee(E)},{id:g.a.DOTNET,instructions:oe(E)},{id:g.a.PHP,instructions:se(E)},{id:g.a.OPEN_TELEMETRY,instructions:ce(E)}]}}function me(){const e=Object(p.a)("/app/apm");return r.a.createElement(l.EuiPanel,{paddingSize:"l"},r.a.createElement(l.EuiFlexGroup,{justifyContent:"spaceBetween",alignItems:"center"},r.a.createElement(l.EuiFlexItem,{grow:!1},r.a.createElement(l.EuiText,null,r.a.createElement("p",null,r.a.createElement(u.FormattedMessage,{id:"xpack.apm.onboarding.footer.exploreYourDataDescription",defaultMessage:"When all steps are complete, you're ready to explore your data."})))),r.a.createElement(l.EuiFlexItem,{grow:!1},r.a.createElement(l.EuiButton,{"data-test-subj":"apmTutorialFooterButton",fill:!0,href:e},c.i18n.translate("xpack.apm.onboarding.footer.cta",{defaultMessage:"Launch APM"})))))}var ge=t(663);function Ee(){const[e,a]=Object(n.useState)([]),[t,c]=Object(n.useState)({apiKey:null,error:!1}),[u,p]=Object(n.useState)(!1),[m,g]=Object(n.useState)(),[E,y]=Object(n.useState)(!1),{services:k}=Object(i.useKibana)(),{config:f}=Object(s.a)(),{docLinks:h,observabilityShared:S}=k,A=(null==h?void 0:h.links.kibana.guide)||"https://www.elastic.co/guide/en/kibana/current/index.html",b=(null==h?void 0:h.ELASTIC_WEBSITE_URL)||"https://www.elastic.co/",M=async()=>{try{p(!0);const e=[ge.a.EVENT],{agentKey:a}=await Object(o.callApmApi)("POST /api/apm/agent_keys 2023-10-31",{signal:null,params:{body:{name:`onboarding-${(Math.random()+1).toString(36).substring(7)}`,privileges:e}}});c({apiKey:a.encoded,id:a.id,error:!1})}catch(a){var e;c({apiKey:null,error:!0,errorMessage:(null===(e=a.body)||void 0===e?void 0:e.message)||a.message})}finally{p(!1)}},T=async()=>{try{y(!0);const e=await Object(o.callApmApi)("GET /internal/apm/observability_overview/has_data",{signal:null});g(e.hasData)}catch(e){g(!1)}finally{y(!1)}},K=e.length>0;Object(n.useEffect)((()=>{a([de({baseUrl:b,config:f,checkAgentStatus:T,agentStatus:m,agentStatusLoading:E},u,t,M)])}),[t,b,f,u,m,E]);const C=S.navigation.PageTemplate;return r.a.createElement(C,null,r.a.createElement(d,{isBeta:!1,guideLink:A}),r.a.createElement(l.EuiSpacer,null),K&&e.map((e=>r.a.createElement("div",{key:e.title},r.a.createElement(v,{instructions:e}),r.a.createElement(l.EuiSpacer,null)))),r.a.createElement(me,null))}}}]);