"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.transactionRouteRepository = void 0;
var _ioTsUtils = require("@kbn/io-ts-utils");
var t = _interopRequireWildcard(require("io-ts"));
var _comparison_rt = require("../../../common/comparison_rt");
var _latency_aggregation_types = require("../../../common/latency_aggregation_types");
var _join_by_key = require("../../../common/utils/join_by_key");
var _get_apm_alerts_client = require("../../lib/helpers/get_apm_alerts_client");
var _get_apm_event_client = require("../../lib/helpers/get_apm_event_client");
var _transactions = require("../../lib/helpers/transactions");
var _get_coldstart_rate = require("../../lib/transaction_groups/get_coldstart_rate");
var _create_apm_server_route = require("../apm_routes/create_apm_server_route");
var _default_api_types = require("../default_api_types");
var _get_service_transaction_groups = require("../services/get_service_transaction_groups");
var _get_service_transaction_groups_alerts = require("../services/get_service_transaction_groups_alerts");
var _get_service_transaction_group_detailed_statistics = require("../services/get_service_transaction_group_detailed_statistics");
var _breakdown = require("./breakdown");
var _get_failed_transaction_rate_periods = require("./get_failed_transaction_rate_periods");
var _get_latency_charts = require("./get_latency_charts");
var _trace_samples = require("./trace_samples");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const transactionGroupsMainStatisticsRoute = (0, _create_apm_server_route.createApmServerRoute)({
  endpoint: 'GET /internal/apm/services/{serviceName}/transactions/groups/main_statistics',
  params: t.type({
    path: t.type({
      serviceName: t.string
    }),
    query: t.intersection([t.partial({
      searchQuery: t.string
    }), _default_api_types.environmentRt, _default_api_types.rangeRt, t.type({
      kuery: t.string,
      useDurationSummary: _ioTsUtils.toBooleanRt,
      transactionType: t.string,
      latencyAggregationType: _latency_aggregation_types.latencyAggregationTypeRt
    }), _default_api_types.transactionDataSourceRt])
  }),
  options: {
    tags: ['access:apm']
  },
  handler: async resources => {
    const {
      params
    } = resources;
    const apmEventClient = await (0, _get_apm_event_client.getApmEventClient)(resources);
    const apmAlertsClient = await (0, _get_apm_alerts_client.getApmAlertsClient)(resources);
    const {
      path: {
        serviceName
      },
      query: {
        environment,
        kuery,
        latencyAggregationType,
        transactionType,
        start,
        end,
        documentType,
        rollupInterval,
        useDurationSummary,
        searchQuery
      }
    } = params;
    const commonProps = {
      environment,
      kuery,
      serviceName,
      transactionType,
      latencyAggregationType,
      start,
      end,
      searchQuery
    };
    const [serviceTransactionGroups, serviceTransactionGroupsAlerts] = await Promise.all([(0, _get_service_transaction_groups.getServiceTransactionGroups)({
      apmEventClient,
      documentType,
      rollupInterval,
      useDurationSummary,
      ...commonProps
    }), (0, _get_service_transaction_groups_alerts.getServiceTransactionGroupsAlerts)({
      apmAlertsClient,
      ...commonProps
    })]);
    const {
      transactionGroups,
      maxCountExceeded,
      transactionOverflowCount
    } = serviceTransactionGroups;
    const transactionGroupsWithAlerts = (0, _join_by_key.joinByKey)([...transactionGroups, ...serviceTransactionGroupsAlerts], 'name');
    return {
      transactionGroups: transactionGroupsWithAlerts,
      maxCountExceeded,
      transactionOverflowCount,
      hasActiveAlerts: !!serviceTransactionGroupsAlerts.length
    };
  }
});
const transactionGroupsDetailedStatisticsRoute = (0, _create_apm_server_route.createApmServerRoute)({
  endpoint: 'GET /internal/apm/services/{serviceName}/transactions/groups/detailed_statistics',
  params: t.type({
    path: t.type({
      serviceName: t.string
    }),
    query: t.intersection([_default_api_types.environmentRt, _default_api_types.kueryRt, _default_api_types.rangeRt, t.intersection([_comparison_rt.offsetRt, _default_api_types.transactionDataSourceRt, t.type({
      bucketSizeInSeconds: _ioTsUtils.toNumberRt,
      useDurationSummary: _ioTsUtils.toBooleanRt
    })]), t.type({
      transactionNames: _ioTsUtils.jsonRt.pipe(t.array(t.string)),
      transactionType: t.string,
      latencyAggregationType: _latency_aggregation_types.latencyAggregationTypeRt
    })])
  }),
  options: {
    tags: ['access:apm']
  },
  handler: async resources => {
    const apmEventClient = await (0, _get_apm_event_client.getApmEventClient)(resources);
    const {
      params
    } = resources;
    const {
      path: {
        serviceName
      },
      query: {
        environment,
        kuery,
        start,
        end,
        offset,
        documentType,
        rollupInterval,
        bucketSizeInSeconds,
        useDurationSummary,
        transactionNames,
        transactionType,
        latencyAggregationType
      }
    } = params;
    return (0, _get_service_transaction_group_detailed_statistics.getServiceTransactionGroupDetailedStatisticsPeriods)({
      environment,
      kuery,
      apmEventClient,
      serviceName,
      transactionNames,
      transactionType,
      documentType,
      rollupInterval,
      bucketSizeInSeconds,
      useDurationSummary,
      latencyAggregationType,
      start,
      end,
      offset
    });
  }
});
const transactionLatencyChartsRoute = (0, _create_apm_server_route.createApmServerRoute)({
  endpoint: 'GET /internal/apm/services/{serviceName}/transactions/charts/latency',
  params: t.type({
    path: t.type({
      serviceName: t.string
    }),
    query: t.intersection([t.type({
      transactionType: t.string,
      latencyAggregationType: _latency_aggregation_types.latencyAggregationTypeRt,
      bucketSizeInSeconds: _ioTsUtils.toNumberRt,
      useDurationSummary: _ioTsUtils.toBooleanRt
    }), t.partial({
      transactionName: t.string,
      filters: _default_api_types.filtersRt
    }), t.intersection([_default_api_types.environmentRt, _default_api_types.kueryRt, _default_api_types.rangeRt, _comparison_rt.offsetRt]), _default_api_types.serviceTransactionDataSourceRt])
  }),
  options: {
    tags: ['access:apm']
  },
  handler: async resources => {
    const apmEventClient = await (0, _get_apm_event_client.getApmEventClient)(resources);
    const {
      params,
      logger
    } = resources;
    const {
      serviceName
    } = params.path;
    const {
      environment,
      kuery,
      filters,
      transactionType,
      transactionName,
      latencyAggregationType,
      start,
      end,
      offset,
      documentType,
      rollupInterval,
      bucketSizeInSeconds,
      useDurationSummary
    } = params.query;
    const options = {
      environment,
      kuery,
      filters,
      serviceName,
      transactionType,
      transactionName,
      apmEventClient,
      logger,
      start,
      end,
      documentType,
      rollupInterval,
      bucketSizeInSeconds,
      useDurationSummary
    };
    return (0, _get_latency_charts.getLatencyPeriods)({
      ...options,
      latencyAggregationType: latencyAggregationType,
      offset
    });
  }
});
const transactionTraceSamplesRoute = (0, _create_apm_server_route.createApmServerRoute)({
  endpoint: 'GET /internal/apm/services/{serviceName}/transactions/traces/samples',
  params: t.type({
    path: t.type({
      serviceName: t.string
    }),
    query: t.intersection([t.type({
      transactionType: t.string,
      transactionName: t.string
    }), t.partial({
      transactionId: t.string,
      traceId: t.string,
      sampleRangeFrom: _ioTsUtils.toNumberRt,
      sampleRangeTo: _ioTsUtils.toNumberRt
    }), _default_api_types.environmentRt, _default_api_types.kueryRt, _default_api_types.rangeRt])
  }),
  options: {
    tags: ['access:apm']
  },
  handler: async resources => {
    const apmEventClient = await (0, _get_apm_event_client.getApmEventClient)(resources);
    const {
      params
    } = resources;
    const {
      serviceName
    } = params.path;
    const {
      environment,
      kuery,
      transactionType,
      transactionName,
      transactionId = '',
      traceId = '',
      sampleRangeFrom,
      sampleRangeTo,
      start,
      end
    } = params.query;
    return (0, _trace_samples.getTraceSamples)({
      environment,
      kuery,
      serviceName,
      transactionType,
      transactionName,
      transactionId,
      traceId,
      sampleRangeFrom,
      sampleRangeTo,
      apmEventClient,
      start,
      end
    });
  }
});
const transactionChartsBreakdownRoute = (0, _create_apm_server_route.createApmServerRoute)({
  endpoint: 'GET /internal/apm/services/{serviceName}/transaction/charts/breakdown',
  params: t.type({
    path: t.type({
      serviceName: t.string
    }),
    query: t.intersection([t.type({
      transactionType: t.string
    }), t.partial({
      transactionName: t.string
    }), _default_api_types.environmentRt, _default_api_types.kueryRt, _default_api_types.rangeRt])
  }),
  options: {
    tags: ['access:apm']
  },
  handler: async resources => {
    const apmEventClient = await (0, _get_apm_event_client.getApmEventClient)(resources);
    const {
      params,
      config
    } = resources;
    const {
      serviceName
    } = params.path;
    const {
      environment,
      kuery,
      transactionName,
      transactionType,
      start,
      end
    } = params.query;
    return (0, _breakdown.getTransactionBreakdown)({
      environment,
      kuery,
      serviceName,
      transactionName,
      transactionType,
      config,
      apmEventClient,
      start,
      end
    });
  }
});
const transactionChartsErrorRateRoute = (0, _create_apm_server_route.createApmServerRoute)({
  endpoint: 'GET /internal/apm/services/{serviceName}/transactions/charts/error_rate',
  params: t.type({
    path: t.type({
      serviceName: t.string
    }),
    query: t.intersection([t.type({
      transactionType: t.string,
      bucketSizeInSeconds: _ioTsUtils.toNumberRt
    }), t.partial({
      transactionName: t.string,
      filters: _default_api_types.filtersRt
    }), t.intersection([_default_api_types.environmentRt, _default_api_types.kueryRt, _default_api_types.rangeRt, _comparison_rt.offsetRt, _default_api_types.serviceTransactionDataSourceRt])])
  }),
  options: {
    tags: ['access:apm']
  },
  handler: async resources => {
    const apmEventClient = await (0, _get_apm_event_client.getApmEventClient)(resources);
    const {
      params
    } = resources;
    const {
      serviceName
    } = params.path;
    const {
      environment,
      kuery,
      filters,
      transactionType,
      transactionName,
      start,
      end,
      offset,
      documentType,
      rollupInterval,
      bucketSizeInSeconds
    } = params.query;
    return (0, _get_failed_transaction_rate_periods.getFailedTransactionRatePeriods)({
      environment,
      kuery,
      filters,
      serviceName,
      transactionType,
      transactionName,
      apmEventClient,
      start,
      end,
      offset,
      documentType,
      rollupInterval,
      bucketSizeInSeconds
    });
  }
});
const transactionChartsColdstartRateRoute = (0, _create_apm_server_route.createApmServerRoute)({
  endpoint: 'GET /internal/apm/services/{serviceName}/transactions/charts/coldstart_rate',
  params: t.type({
    path: t.type({
      serviceName: t.string
    }),
    query: t.intersection([t.type({
      transactionType: t.string
    }), t.intersection([_default_api_types.environmentRt, _default_api_types.kueryRt, _default_api_types.rangeRt, _comparison_rt.offsetRt])])
  }),
  options: {
    tags: ['access:apm']
  },
  handler: async resources => {
    const apmEventClient = await (0, _get_apm_event_client.getApmEventClient)(resources);
    const {
      params,
      config
    } = resources;
    const {
      serviceName
    } = params.path;
    const {
      environment,
      kuery,
      transactionType,
      start,
      end,
      offset
    } = params.query;
    const searchAggregatedTransactions = await (0, _transactions.getSearchTransactionsEvents)({
      config,
      apmEventClient,
      kuery,
      start,
      end
    });
    return (0, _get_coldstart_rate.getColdstartRatePeriods)({
      environment,
      kuery,
      serviceName,
      transactionType,
      apmEventClient,
      searchAggregatedTransactions,
      start,
      end,
      offset
    });
  }
});
const transactionChartsColdstartRateByTransactionNameRoute = (0, _create_apm_server_route.createApmServerRoute)({
  endpoint: 'GET /internal/apm/services/{serviceName}/transactions/charts/coldstart_rate_by_transaction_name',
  params: t.type({
    path: t.type({
      serviceName: t.string
    }),
    query: t.intersection([t.type({
      transactionType: t.string,
      transactionName: t.string
    }), t.intersection([_default_api_types.environmentRt, _default_api_types.kueryRt, _default_api_types.rangeRt, _comparison_rt.offsetRt])])
  }),
  options: {
    tags: ['access:apm']
  },
  handler: async resources => {
    const apmEventClient = await (0, _get_apm_event_client.getApmEventClient)(resources);
    const {
      params,
      config
    } = resources;
    const {
      serviceName
    } = params.path;
    const {
      environment,
      kuery,
      transactionType,
      transactionName,
      start,
      end,
      offset
    } = params.query;
    const searchAggregatedTransactions = await (0, _transactions.getSearchTransactionsEvents)({
      config,
      apmEventClient,
      kuery,
      start,
      end
    });
    return (0, _get_coldstart_rate.getColdstartRatePeriods)({
      environment,
      kuery,
      serviceName,
      transactionType,
      transactionName,
      apmEventClient,
      searchAggregatedTransactions,
      start,
      end,
      offset
    });
  }
});
const transactionRouteRepository = exports.transactionRouteRepository = {
  ...transactionGroupsMainStatisticsRoute,
  ...transactionGroupsDetailedStatisticsRoute,
  ...transactionLatencyChartsRoute,
  ...transactionTraceSamplesRoute,
  ...transactionChartsBreakdownRoute,
  ...transactionChartsErrorRateRoute,
  ...transactionChartsColdstartRateRoute,
  ...transactionChartsColdstartRateByTransactionNameRoute
};