"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getLinkedParentsOfSpan = getLinkedParentsOfSpan;
var _server = require("@kbn/observability-plugin/server");
var _common = require("@kbn/observability-plugin/common");
var _apm = require("../../../common/es_fields/apm");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function getLinkedParentsOfSpan({
  apmEventClient,
  traceId,
  spanId,
  start,
  end,
  processorEvent
}) {
  var _response$hits$hits, _response$hits$hits$, _source$span;
  const response = await apmEventClient.search('get_linked_parents_of_span', {
    apm: {
      events: [processorEvent]
    },
    _source: [_apm.SPAN_LINKS],
    body: {
      track_total_hits: false,
      size: 1,
      query: {
        bool: {
          filter: [...(0, _server.rangeQuery)(start, end), {
            term: {
              [_apm.TRACE_ID]: traceId
            }
          }, {
            exists: {
              field: _apm.SPAN_LINKS
            }
          }, {
            term: {
              [_apm.PROCESSOR_EVENT]: processorEvent
            }
          }, ...(processorEvent === _common.ProcessorEvent.transaction ? [{
            term: {
              [_apm.TRANSACTION_ID]: spanId
            }
          }] : [{
            term: {
              [_apm.SPAN_ID]: spanId
            }
          }])]
        }
      }
    }
  });
  const source = (_response$hits$hits = response.hits.hits) === null || _response$hits$hits === void 0 ? void 0 : (_response$hits$hits$ = _response$hits$hits[0]) === null || _response$hits$hits$ === void 0 ? void 0 : _response$hits$hits$._source;
  return (source === null || source === void 0 ? void 0 : (_source$span = source.span) === null || _source$span === void 0 ? void 0 : _source$span.links) || [];
}