"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.profilingRouteRepository = void 0;
var _ioTsUtils = require("@kbn/io-ts-utils");
var t = _interopRequireWildcard(require("io-ts"));
var _common = require("@kbn/observability-plugin/common");
var _get_apm_event_client = require("../../lib/helpers/get_apm_event_client");
var _create_apm_server_route = require("../apm_routes/create_apm_server_route");
var _default_api_types = require("../default_api_types");
var _fetch_flamegraph = require("./fetch_flamegraph");
var _fetch_functions = require("./fetch_functions");
var _apm = require("../../../common/es_fields/apm");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const servicesFlamegraphRoute = (0, _create_apm_server_route.createApmServerRoute)({
  endpoint: 'GET /internal/apm/services/{serviceName}/profiling/flamegraph',
  params: t.type({
    path: t.type({
      serviceName: t.string
    }),
    query: t.intersection([_default_api_types.kueryRt, _default_api_types.environmentRt, t.partial({
      transactionName: t.string
    }), t.type({
      start: _ioTsUtils.isoToEpochSecsRt,
      end: _ioTsUtils.isoToEpochSecsRt,
      transactionType: t.string
    })])
  }),
  options: {
    tags: ['access:apm']
  },
  handler: async resources => {
    var _plugins$profilingDat;
    const {
      context,
      plugins,
      params
    } = resources;
    const core = await context.core;
    const [esClient, profilingDataAccessStart, apmEventClient] = await Promise.all([core.elasticsearch.client, await ((_plugins$profilingDat = plugins.profilingDataAccess) === null || _plugins$profilingDat === void 0 ? void 0 : _plugins$profilingDat.start()), (0, _get_apm_event_client.getApmEventClient)(resources)]);
    if (profilingDataAccessStart) {
      const {
        serviceName
      } = params.path;
      const {
        start,
        end,
        kuery,
        transactionName,
        transactionType,
        environment
      } = params.query;
      const indices = apmEventClient.getIndicesFromProcessorEvent(_common.ProcessorEvent.transaction);
      return (0, _fetch_flamegraph.fetchFlamegraph)({
        profilingDataAccessStart,
        core,
        esClient: esClient.asCurrentUser,
        start,
        end,
        kuery,
        serviceName,
        transactionName,
        environment,
        transactionType,
        indices,
        stacktraceIdsField: _apm.TRANSACTION_PROFILER_STACK_TRACE_IDS
      });
    }
    return undefined;
  }
});
const servicesFunctionsRoute = (0, _create_apm_server_route.createApmServerRoute)({
  endpoint: 'GET /internal/apm/services/{serviceName}/profiling/functions',
  params: t.type({
    path: t.type({
      serviceName: t.string
    }),
    query: t.intersection([_default_api_types.environmentRt, t.partial({
      transactionName: t.string
    }), t.type({
      start: _ioTsUtils.isoToEpochSecsRt,
      end: _ioTsUtils.isoToEpochSecsRt,
      startIndex: _ioTsUtils.toNumberRt,
      endIndex: _ioTsUtils.toNumberRt,
      transactionType: t.string
    }), _default_api_types.kueryRt])
  }),
  options: {
    tags: ['access:apm']
  },
  handler: async resources => {
    var _plugins$profilingDat2;
    const {
      context,
      plugins,
      params
    } = resources;
    const core = await context.core;
    const [esClient, profilingDataAccessStart, apmEventClient] = await Promise.all([core.elasticsearch.client, await ((_plugins$profilingDat2 = plugins.profilingDataAccess) === null || _plugins$profilingDat2 === void 0 ? void 0 : _plugins$profilingDat2.start()), (0, _get_apm_event_client.getApmEventClient)(resources)]);
    if (profilingDataAccessStart) {
      const {
        start,
        end,
        startIndex,
        endIndex,
        kuery,
        transactionName,
        transactionType,
        environment
      } = params.query;
      const {
        serviceName
      } = params.path;
      const indices = apmEventClient.getIndicesFromProcessorEvent(_common.ProcessorEvent.transaction);
      return (0, _fetch_functions.fetchFunctions)({
        profilingDataAccessStart,
        core,
        esClient: esClient.asCurrentUser,
        startIndex,
        endIndex,
        indices,
        stacktraceIdsField: _apm.TRANSACTION_PROFILER_STACK_TRACE_IDS,
        start,
        end,
        kuery,
        serviceName,
        transactionName,
        environment,
        transactionType
      });
    }
    return undefined;
  }
});
const profilingStatusRoute = (0, _create_apm_server_route.createApmServerRoute)({
  endpoint: 'GET /internal/apm/profiling/status',
  options: {
    tags: ['access:apm']
  },
  handler: async resources => {
    var _plugins$profilingDat3;
    const {
      context,
      plugins,
      logger
    } = resources;
    const [esClient, profilingDataAccessStart] = await Promise.all([(await context.core).elasticsearch.client, await ((_plugins$profilingDat3 = plugins.profilingDataAccess) === null || _plugins$profilingDat3 === void 0 ? void 0 : _plugins$profilingDat3.start())]);
    if (profilingDataAccessStart) {
      try {
        var _await$plugins$spaces, _plugins$spaces;
        const response = await (profilingDataAccessStart === null || profilingDataAccessStart === void 0 ? void 0 : profilingDataAccessStart.services.getStatus({
          esClient,
          soClient: (await context.core).savedObjects.client,
          spaceId: (_await$plugins$spaces = await ((_plugins$spaces = plugins.spaces) === null || _plugins$spaces === void 0 ? void 0 : _plugins$spaces.start())) === null || _await$plugins$spaces === void 0 ? void 0 : _await$plugins$spaces.spacesService.getSpaceId(resources.request)
        }));
        return {
          initialized: response.has_setup
        };
      } catch (e) {
        // If any error happens just return as if profiling has not been initialized
        logger.warn('Could not check Universal Profiling status');
      }
    }
    return {
      initialized: false
    };
  }
});
const profilingRouteRepository = exports.profilingRouteRepository = {
  ...servicesFlamegraphRoute,
  ...profilingStatusRoute,
  ...servicesFunctionsRoute
};