"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.mobileErrorRoutes = void 0;
var t = _interopRequireWildcard(require("io-ts"));
var _ioTsUtils = require("@kbn/io-ts-utils");
var _get_apm_event_client = require("../../../lib/helpers/get_apm_event_client");
var _create_apm_server_route = require("../../apm_routes/create_apm_server_route");
var _default_api_types = require("../../default_api_types");
var _comparison_rt = require("../../../../common/comparison_rt");
var _get_mobile_error_group_detailed_statistics = require("./get_mobile_error_group_detailed_statistics");
var _get_mobile_error_group_main_statistics = require("./get_mobile_error_group_main_statistics");
var _get_mobile_errors_terms_by_field = require("./get_mobile_errors_terms_by_field");
var _get_mobile_http_errors = require("./get_mobile_http_errors");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const mobileMobileHttpRatesRoute = (0, _create_apm_server_route.createApmServerRoute)({
  endpoint: 'GET /internal/apm/mobile-services/{serviceName}/error/http_error_rate',
  params: t.type({
    path: t.type({
      serviceName: t.string
    }),
    query: t.intersection([_default_api_types.environmentRt, _default_api_types.kueryRt, _default_api_types.rangeRt, _comparison_rt.offsetRt])
  }),
  options: {
    tags: ['access:apm']
  },
  handler: async resources => {
    const apmEventClient = await (0, _get_apm_event_client.getApmEventClient)(resources);
    const {
      params
    } = resources;
    const {
      serviceName
    } = params.path;
    const {
      kuery,
      environment,
      start,
      end,
      offset
    } = params.query;
    const response = await (0, _get_mobile_http_errors.getMobileHttpErrors)({
      kuery,
      environment,
      start,
      end,
      serviceName,
      apmEventClient,
      offset
    });
    return {
      ...response
    };
  }
});
const mobileErrorsDetailedStatisticsRoute = (0, _create_apm_server_route.createApmServerRoute)({
  endpoint: 'POST /internal/apm/mobile-services/{serviceName}/errors/groups/detailed_statistics',
  params: t.type({
    path: t.type({
      serviceName: t.string
    }),
    query: t.intersection([_default_api_types.environmentRt, _default_api_types.kueryRt, _default_api_types.rangeRt, _comparison_rt.offsetRt, t.type({
      numBuckets: _ioTsUtils.toNumberRt
    })]),
    body: t.type({
      groupIds: _ioTsUtils.jsonRt.pipe(t.array(t.string))
    })
  }),
  options: {
    tags: ['access:apm']
  },
  handler: async resources => {
    const apmEventClient = await (0, _get_apm_event_client.getApmEventClient)(resources);
    const {
      params
    } = resources;
    const {
      path: {
        serviceName
      },
      query: {
        environment,
        kuery,
        numBuckets,
        start,
        end,
        offset
      },
      body: {
        groupIds
      }
    } = params;
    return (0, _get_mobile_error_group_detailed_statistics.getMobileErrorGroupPeriods)({
      environment,
      kuery,
      serviceName,
      apmEventClient,
      numBuckets,
      groupIds,
      start,
      end,
      offset
    });
  }
});
const mobileErrorTermsByFieldRoute = (0, _create_apm_server_route.createApmServerRoute)({
  endpoint: 'GET /internal/apm/mobile-services/{serviceName}/error_terms',
  params: t.type({
    path: t.type({
      serviceName: t.string
    }),
    query: t.intersection([_default_api_types.kueryRt, _default_api_types.rangeRt, _default_api_types.environmentRt, t.type({
      size: _ioTsUtils.toNumberRt,
      fieldName: t.string
    })])
  }),
  options: {
    tags: ['access:apm']
  },
  handler: async resources => {
    const apmEventClient = await (0, _get_apm_event_client.getApmEventClient)(resources);
    const {
      params
    } = resources;
    const {
      serviceName
    } = params.path;
    const {
      kuery,
      environment,
      start,
      end,
      size,
      fieldName
    } = params.query;
    const terms = await (0, _get_mobile_errors_terms_by_field.getMobileErrorsTermsByField)({
      kuery,
      environment,
      start,
      end,
      serviceName,
      apmEventClient,
      fieldName,
      size
    });
    return {
      terms
    };
  }
});
const mobileErrorsMainStatisticsRoute = (0, _create_apm_server_route.createApmServerRoute)({
  endpoint: 'GET /internal/apm/mobile-services/{serviceName}/errors/groups/main_statistics',
  params: t.type({
    path: t.type({
      serviceName: t.string
    }),
    query: t.intersection([t.partial({
      sortField: t.string,
      sortDirection: t.union([t.literal('asc'), t.literal('desc')])
    }), _default_api_types.environmentRt, _default_api_types.kueryRt, _default_api_types.rangeRt])
  }),
  options: {
    tags: ['access:apm']
  },
  handler: async resources => {
    const {
      params
    } = resources;
    const apmEventClient = await (0, _get_apm_event_client.getApmEventClient)(resources);
    const {
      serviceName
    } = params.path;
    const {
      environment,
      kuery,
      sortField,
      sortDirection,
      start,
      end
    } = params.query;
    const errorGroups = await (0, _get_mobile_error_group_main_statistics.getMobileErrorGroupMainStatistics)({
      environment,
      kuery,
      serviceName,
      sortField,
      sortDirection,
      apmEventClient,
      start,
      end
    });
    return {
      errorGroups
    };
  }
});
const mobileErrorRoutes = exports.mobileErrorRoutes = {
  ...mobileMobileHttpRatesRoute,
  ...mobileErrorsMainStatisticsRoute,
  ...mobileErrorsDetailedStatisticsRoute,
  ...mobileErrorTermsByFieldRoute
};