"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.servicesEntitiesRoutesRepository = void 0;
var t = _interopRequireWildcard(require("io-ts"));
var _environment_query = require("../../../../common/utils/environment_query");
var _create_entities_es_client = require("../../../lib/helpers/create_es_client/create_entities_es_client/create_entities_es_client");
var _create_apm_server_route = require("../../apm_routes/create_apm_server_route");
var _default_api_types = require("../../default_api_types");
var _get_service_entities = require("./get_service_entities");
var _get_service_entity_summary = require("./get_service_entity_summary");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const serviceEntitiesSummaryRoute = (0, _create_apm_server_route.createApmServerRoute)({
  endpoint: 'GET /internal/apm/entities/services/{serviceName}/summary',
  params: t.type({
    path: t.type({
      serviceName: t.string
    }),
    query: _default_api_types.environmentRt
  }),
  options: {
    tags: ['access:apm']
  },
  async handler(resources) {
    const {
      context,
      params,
      request
    } = resources;
    const coreContext = await context.core;
    const entitiesESClient = await (0, _create_entities_es_client.createEntitiesESClient)({
      request,
      esClient: coreContext.elasticsearch.client.asCurrentUser
    });
    const {
      serviceName
    } = params.path;
    const {
      environment
    } = params.query;
    return (0, _get_service_entity_summary.getServiceEntitySummary)({
      entitiesESClient,
      serviceName,
      environment
    });
  }
});
const servicesEntitiesRoute = (0, _create_apm_server_route.createApmServerRoute)({
  endpoint: 'GET /internal/apm/entities/services',
  params: t.type({
    query: t.intersection([_default_api_types.environmentRt, _default_api_types.kueryRt, _default_api_types.rangeRt])
  }),
  options: {
    tags: ['access:apm']
  },
  async handler(resources) {
    const {
      context,
      params,
      request
    } = resources;
    const coreContext = await context.core;
    const entitiesESClient = await (0, _create_entities_es_client.createEntitiesESClient)({
      request,
      esClient: coreContext.elasticsearch.client.asCurrentUser
    });
    const {
      start,
      end,
      kuery,
      environment
    } = params.query;
    const services = await (0, _get_service_entities.getServiceEntities)({
      entitiesESClient,
      start,
      end,
      kuery,
      environment,
      logger: resources.logger
    });
    return {
      services
    };
  }
});
const serviceLogRateTimeseriesRoute = (0, _create_apm_server_route.createApmServerRoute)({
  endpoint: 'GET /internal/apm/entities/services/{serviceName}/logs_rate_timeseries',
  params: t.type({
    path: t.type({
      serviceName: t.string
    }),
    query: t.intersection([_default_api_types.environmentRt, _default_api_types.kueryRt, _default_api_types.rangeRt])
  }),
  options: {
    tags: ['access:apm']
  },
  async handler(resources) {
    const {
      context,
      params,
      plugins
    } = resources;
    const [coreContext, logsDataAccessStart] = await Promise.all([context.core, plugins.logsDataAccess.start()]);
    const {
      serviceName
    } = params.path;
    const {
      start,
      end,
      kuery,
      environment
    } = params.query;
    const currentPeriodLogsRateTimeseries = await logsDataAccessStart.services.getLogsRateTimeseries({
      esClient: coreContext.elasticsearch.client.asCurrentUser,
      identifyingMetadata: 'service.name',
      timeFrom: start,
      timeTo: end,
      kuery,
      serviceEnvironmentQuery: (0, _environment_query.environmentQuery)(environment),
      serviceNames: [serviceName]
    });
    return {
      currentPeriod: currentPeriodLogsRateTimeseries
    };
  }
});
const serviceLogErrorRateTimeseriesRoute = (0, _create_apm_server_route.createApmServerRoute)({
  endpoint: 'GET /internal/apm/entities/services/{serviceName}/logs_error_rate_timeseries',
  params: t.type({
    path: t.type({
      serviceName: t.string
    }),
    query: t.intersection([_default_api_types.environmentRt, _default_api_types.kueryRt, _default_api_types.rangeRt])
  }),
  options: {
    tags: ['access:apm']
  },
  async handler(resources) {
    const {
      context,
      params,
      plugins
    } = resources;
    const [coreContext, logsDataAccessStart] = await Promise.all([context.core, plugins.logsDataAccess.start()]);
    const {
      serviceName
    } = params.path;
    const {
      start,
      end,
      kuery,
      environment
    } = params.query;
    const logsErrorRateTimeseries = await logsDataAccessStart.services.getLogsErrorRateTimeseries({
      esClient: coreContext.elasticsearch.client.asCurrentUser,
      identifyingMetadata: 'service.name',
      timeFrom: start,
      timeTo: end,
      kuery,
      serviceEnvironmentQuery: (0, _environment_query.environmentQuery)(environment),
      serviceNames: [serviceName]
    });
    return {
      currentPeriod: logsErrorRateTimeseries
    };
  }
});
const servicesEntitiesRoutesRepository = exports.servicesEntitiesRoutesRepository = {
  ...servicesEntitiesRoute,
  ...serviceLogRateTimeseriesRoute,
  ...serviceLogErrorRateTimeseriesRoute,
  ...serviceEntitiesSummaryRoute
};