"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getServiceEntitySummary = getServiceEntitySummary;
var _with_apm_span = require("../../../utils/with_apm_span");
var _get_entity_latest_services = require("../get_entity_latest_services");
var _merge_entities = require("../utils/merge_entities");
var _get_service_entities = require("./get_service_entities");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function getServiceEntitySummary({
  entitiesESClient,
  environment,
  serviceName
}) {
  return (0, _with_apm_span.withApmSpan)('get_service_entity_summary', async () => {
    const entityLatestServices = await (0, _get_entity_latest_services.getEntityLatestServices)({
      entitiesESClient,
      environment,
      size: _get_service_entities.MAX_NUMBER_OF_SERVICES,
      serviceName
    });
    const serviceEntity = (0, _merge_entities.mergeEntities)({
      entities: entityLatestServices
    });
    return serviceEntity[0];
  });
}