"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getEntityLatestServices = getEntityLatestServices;
var _server = require("@kbn/observability-plugin/server");
var _elasticsearch = require("@kbn/observability-shared-plugin/common/field_names/elasticsearch");
var _apm = require("../../../common/es_fields/apm");
var _environment_query = require("../../../common/utils/environment_query");
var _get_entities = require("./get_entities");
var _types = require("./types");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function getEntityLatestServices({
  entitiesESClient,
  start,
  end,
  environment,
  kuery,
  size,
  serviceName
}) {
  const latestEntityServices = (await entitiesESClient.searchLatest(`get_entity_latest_services`, {
    body: {
      size,
      track_total_hits: false,
      _source: [_apm.AGENT_NAME, _elasticsearch.ENTITY, _elasticsearch.SOURCE_DATA_STREAM_TYPE, _apm.SERVICE_NAME, _apm.SERVICE_ENVIRONMENT],
      query: {
        bool: {
          filter: [...(0, _server.kqlQuery)(kuery), ...(0, _environment_query.environmentQuery)(environment, _apm.SERVICE_ENVIRONMENT), ...(0, _get_entities.entitiesRangeQuery)(start, end), ...(0, _server.termQuery)(_elasticsearch.ENTITY_TYPE, _types.EntityType.SERVICE), ...(0, _server.termQuery)(_apm.SERVICE_NAME, serviceName)]
        }
      }
    }
  })).hits.hits.map(hit => hit._source);
  return latestEntityServices;
}