"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.entitiesRangeQuery = entitiesRangeQuery;
exports.getEntities = getEntities;
var _elasticsearch = require("@kbn/observability-shared-plugin/common/field_names/elasticsearch");
var _get_entity_latest_services = require("./get_entity_latest_services");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function entitiesRangeQuery(start, end) {
  if (!start || !end) {
    return [];
  }
  return [{
    range: {
      [_elasticsearch.ENTITY_LAST_SEEN]: {
        gte: start
      }
    }
  }, {
    range: {
      [_elasticsearch.ENTITY_FIRST_SEEN]: {
        lte: end
      }
    }
  }];
}
async function getEntities({
  entitiesESClient,
  start,
  end,
  environment,
  kuery,
  size,
  serviceName
}) {
  const entityLatestServices = await (0, _get_entity_latest_services.getEntityLatestServices)({
    entitiesESClient,
    start,
    end,
    environment,
    kuery,
    size,
    serviceName
  });
  return entityLatestServices;
}