"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.diagnosticsRepository = void 0;
var t = _interopRequireWildcard(require("io-ts"));
var _ioTsUtils = require("@kbn/io-ts-utils");
var _create_apm_server_route = require("../apm_routes/create_apm_server_route");
var _get_diagnostics_bundle = require("./get_diagnostics_bundle");
var _get_fleet_package_info = require("./get_fleet_package_info");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getDiagnosticsRoute = (0, _create_apm_server_route.createApmServerRoute)({
  endpoint: 'GET /internal/apm/diagnostics',
  options: {
    tags: ['access:apm']
  },
  params: t.partial({
    query: t.partial({
      kuery: t.string,
      start: _ioTsUtils.isoToEpochRt,
      end: _ioTsUtils.isoToEpochRt
    })
  }),
  handler: async resources => {
    const {
      start,
      end,
      kuery
    } = resources.params.query;
    const coreContext = await resources.context.core;
    const apmIndices = await resources.getApmIndices();
    const {
      asCurrentUser: esClient
    } = coreContext.elasticsearch.client;
    const bundle = await (0, _get_diagnostics_bundle.getDiagnosticsBundle)({
      esClient,
      apmIndices,
      start,
      end,
      kuery
    });
    const fleetPackageInfo = await (0, _get_fleet_package_info.getFleetPackageInfo)(resources);
    const kibanaVersion = resources.kibanaVersion;
    return {
      ...bundle,
      fleetPackageInfo,
      kibanaVersion
    };
  }
});
const diagnosticsRepository = exports.diagnosticsRepository = {
  ...getDiagnosticsRoute
};