"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getDurationField = getDurationField;
var _apm = require("../../../../common/es_fields/apm");
var _latency_distribution_chart_types = require("../../../../common/latency_distribution_chart_types");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const {
  transactionLatency,
  latencyCorrelations,
  failedTransactionsCorrelations,
  dependencyLatency
} = _latency_distribution_chart_types.LatencyDistributionChartType;
function getDurationField(chartType, searchMetrics) {
  switch (chartType) {
    case transactionLatency:
      if (searchMetrics) {
        return _apm.TRANSACTION_DURATION_HISTOGRAM;
      }
      return _apm.TRANSACTION_DURATION;
    case latencyCorrelations:
      return _apm.TRANSACTION_DURATION;
    case failedTransactionsCorrelations:
      return _apm.TRANSACTION_DURATION;
    case dependencyLatency:
      return _apm.SPAN_DURATION;
    default:
      return _apm.TRANSACTION_DURATION;
  }
}