"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getLogCategories = getLogCategories;
var _datemath = _interopRequireDefault(require("@elastic/datemath"));
var _utils = require("@kbn/apm-data-access-plugin/server/utils");
var _maybe2 = require("../../../../common/utils/maybe");
var _as_mutable_array = require("../../../../common/utils/as_mutable_array");
var _flatten_object = require("../../../../common/utils/flatten_object");
var _apm = require("../../../../common/es_fields/apm");
var _create_typed_es_client = require("../../../utils/create_typed_es_client");
var _get_downstream_dependency_name = require("../get_observability_alert_details_context/get_downstream_dependency_name");
var _get_should_match_or_not_exist_filter = require("../utils/get_should_match_or_not_exist_filter");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function getLogCategories({
  apmEventClient,
  esClient,
  logSourcesService,
  arguments: args
}) {
  var _datemath$parse, _datemath$parse2, _categorizedLogsRes$a, _categorizedLogsRes$a2, _maybe;
  const start = (_datemath$parse = _datemath.default.parse(args.start)) === null || _datemath$parse === void 0 ? void 0 : _datemath$parse.valueOf();
  const end = (_datemath$parse2 = _datemath.default.parse(args.end)) === null || _datemath$parse2 === void 0 ? void 0 : _datemath$parse2.valueOf();
  const keyValueFilters = (0, _get_should_match_or_not_exist_filter.getShouldMatchOrNotExistFilter)(Object.entries(args.entities).map(([key, value]) => ({
    field: key,
    value
  })));
  const index = await logSourcesService.getFlattenedLogSources();
  const search = (0, _create_typed_es_client.getTypedSearch)(esClient);
  const query = {
    bool: {
      must_not: [
      // exclude APM errors
      {
        term: {
          [_apm.PROCESSOR_EVENT]: 'error'
        }
      }],
      filter: [...keyValueFilters, {
        exists: {
          field: 'message'
        }
      }, {
        range: {
          '@timestamp': {
            gte: start,
            lte: end
          }
        }
      }]
    }
  };
  const hitCountRes = await search({
    index,
    size: 0,
    track_total_hits: true,
    query
  });
  const totalDocCount = hitCountRes.hits.total.value;
  const rawSamplingProbability = Math.min(100_000 / totalDocCount, 1);
  const samplingProbability = rawSamplingProbability < 0.5 ? rawSamplingProbability : 1;
  const fields = (0, _as_mutable_array.asMutableArray)(['message', _apm.TRACE_ID]);
  const categorizedLogsRes = await search({
    index,
    size: 1,
    _source: Object.keys(args.entities),
    track_total_hits: 0,
    query,
    aggs: {
      sampling: {
        random_sampler: {
          probability: samplingProbability
        },
        aggs: {
          categories: {
            categorize_text: {
              field: 'message',
              size: 10
            },
            aggs: {
              sample: {
                top_hits: {
                  sort: {
                    '@timestamp': 'desc'
                  },
                  size: 1,
                  fields
                }
              }
            }
          }
        }
      }
    }
  });
  const promises = (_categorizedLogsRes$a = categorizedLogsRes.aggregations) === null || _categorizedLogsRes$a === void 0 ? void 0 : (_categorizedLogsRes$a2 = _categorizedLogsRes$a.sampling.categories) === null || _categorizedLogsRes$a2 === void 0 ? void 0 : _categorizedLogsRes$a2.buckets.map(async ({
    doc_count: docCount,
    key,
    sample
  }) => {
    var _event$trace;
    const hit = sample.hits.hits[0];
    const event = (0, _utils.unflattenKnownApmEventFields)(hit === null || hit === void 0 ? void 0 : hit.fields);
    const sampleMessage = event.message;
    const sampleTraceId = (_event$trace = event.trace) === null || _event$trace === void 0 ? void 0 : _event$trace.id;
    const errorCategory = key;
    if (!sampleTraceId) {
      return {
        errorCategory,
        docCount,
        sampleMessage
      };
    }
    const downstreamServiceResource = await (0, _get_downstream_dependency_name.getDownstreamServiceResource)({
      traceId: sampleTraceId,
      start,
      end,
      apmEventClient
    });
    return {
      errorCategory,
      docCount,
      sampleMessage,
      downstreamServiceResource
    };
  });
  const event = (0, _utils.unflattenKnownApmEventFields)((_maybe = (0, _maybe2.maybe)(categorizedLogsRes.hits.hits[0])) === null || _maybe === void 0 ? void 0 : _maybe.fields);
  const sampleDoc = event;
  return {
    logCategories: await Promise.all(promises !== null && promises !== void 0 ? promises : []),
    entities: (0, _flatten_object.flattenObject)(sampleDoc)
  };
}