"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getApmAlertsClient = getApmAlertsClient;
var _lodash = require("lodash");
var _ui_settings_keys = require("@kbn/observability-plugin/common/ui_settings_keys");
var _utils = require("@kbn/apm-data-access-plugin/server/utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function getApmAlertsClient({
  context,
  plugins,
  request
}) {
  const coreContext = await context.core;
  const ruleRegistryPluginStart = await plugins.ruleRegistry.start();
  const alertsClient = await ruleRegistryPluginStart.getRacClientWithRequest(request);
  const apmAlertsIndices = await alertsClient.getAuthorizedAlertsIndices(['apm']);
  if (!apmAlertsIndices || (0, _lodash.isEmpty)(apmAlertsIndices)) {
    throw Error('No alert indices exist for "apm"');
  }
  const excludedDataTiers = await coreContext.uiSettings.client.get(_ui_settings_keys.searchExcludedDataTiers);
  return {
    search(searchParams) {
      return alertsClient.find({
        ...searchParams,
        query: (0, _utils.getDataTierFilterCombined)({
          filter: searchParams.query,
          excludedDataTiers
        }),
        index: apmAlertsIndices.join(',')
      });
    }
  };
}