"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "APMPlugin", {
  enumerable: true,
  get: function () {
    return _plugin.APMPlugin;
  }
});
Object.defineProperty(exports, "APM_SERVER_FEATURE_ID", {
  enumerable: true,
  get: function () {
    return _apm_rule_types.APM_SERVER_FEATURE_ID;
  }
});
exports.plugin = exports.config = void 0;
var _configSchema = require("@kbn/config-schema");
var _common = require("@kbn/observability-plugin/common");
var _aggregated_transactions = require("../common/aggregated_transactions");
var _apm_rule_types = require("../common/rules/apm_rule_types");
var _plugin = require("./plugin");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const disabledOnServerless = (0, _configSchema.offeringBasedSchema)({
  serverless: _configSchema.schema.boolean({
    defaultValue: false
  }),
  traditional: _configSchema.schema.oneOf([_configSchema.schema.literal(true)], {
    defaultValue: true
  })
});

// All options should be documented in the APM configuration settings: https://github.com/elastic/kibana/blob/main/docs/settings/apm-settings.asciidoc
// and be included on cloud allow list unless there are specific reasons not to
const configSchema = _configSchema.schema.object({
  autoCreateApmDataView: _configSchema.schema.boolean({
    defaultValue: true
  }),
  serviceMapEnabled: _configSchema.schema.boolean({
    defaultValue: true
  }),
  serviceMapFingerprintBucketSize: _configSchema.schema.number({
    defaultValue: 100
  }),
  serviceMapFingerprintGlobalBucketSize: _configSchema.schema.number({
    defaultValue: 1000
  }),
  serviceMapMaxAllowableBytes: _configSchema.schema.number({
    defaultValue: 2_576_980_377
  }),
  // 2.4GB
  serviceMapTraceIdBucketSize: _configSchema.schema.number({
    defaultValue: 65
  }),
  serviceMapTraceIdGlobalBucketSize: _configSchema.schema.number({
    defaultValue: 6
  }),
  serviceMapMaxTracesPerRequest: _configSchema.schema.number({
    defaultValue: 50
  }),
  serviceMapTerminateAfter: _configSchema.schema.number({
    defaultValue: 100_000
  }),
  serviceMapMaxTraces: _configSchema.schema.number({
    defaultValue: 1000
  }),
  ui: _configSchema.schema.object({
    enabled: _configSchema.schema.boolean({
      defaultValue: true
    }),
    maxTraceItems: _configSchema.schema.number({
      defaultValue: 5000
    })
  }),
  searchAggregatedTransactions: _configSchema.schema.oneOf([_configSchema.schema.literal(_aggregated_transactions.SearchAggregatedTransactionSetting.auto), _configSchema.schema.literal(_aggregated_transactions.SearchAggregatedTransactionSetting.always), _configSchema.schema.literal(_aggregated_transactions.SearchAggregatedTransactionSetting.never)], {
    defaultValue: _aggregated_transactions.SearchAggregatedTransactionSetting.auto
  }),
  telemetryCollectionEnabled: _configSchema.schema.boolean({
    defaultValue: true
  }),
  metricsInterval: _configSchema.schema.number({
    defaultValue: 30
  }),
  agent: _configSchema.schema.object({
    migrations: _configSchema.schema.object({
      enabled: _configSchema.schema.boolean({
        defaultValue: false
      })
    })
  }),
  forceSyntheticSource: _configSchema.schema.boolean({
    defaultValue: false
  }),
  // deprecated
  latestAgentVersionsUrl: _configSchema.schema.string({
    defaultValue: 'https://apm-agent-versions.elastic.co/versions.json'
  }),
  enabled: _configSchema.schema.boolean({
    defaultValue: true
  }),
  serverlessOnboarding: (0, _configSchema.offeringBasedSchema)({
    serverless: _configSchema.schema.boolean({
      defaultValue: false
    })
  }),
  managedServiceUrl: (0, _configSchema.offeringBasedSchema)({
    serverless: _configSchema.schema.string({
      defaultValue: ''
    })
  }),
  featureFlags: _configSchema.schema.object({
    agentConfigurationAvailable: disabledOnServerless,
    configurableIndicesAvailable: disabledOnServerless,
    infrastructureTabAvailable: disabledOnServerless,
    infraUiAvailable: disabledOnServerless,
    migrationToFleetAvailable: disabledOnServerless,
    sourcemapApiAvailable: disabledOnServerless,
    storageExplorerAvailable: disabledOnServerless,
    /**
     * Depends on optional "profilingDataAccess" and "profiling"
     * plugins. Enable both with `xpack.profiling.enabled: true` before
     * enabling this feature flag.
     */
    profilingIntegrationAvailable: _configSchema.schema.boolean({
      defaultValue: false
    }),
    ruleFormV2Enabled: _configSchema.schema.boolean({
      defaultValue: false
    })
  }),
  serverless: _configSchema.schema.object({
    enabled: (0, _configSchema.offeringBasedSchema)({
      serverless: _configSchema.schema.literal(true),
      options: {
        defaultValue: _configSchema.schema.contextRef('serverless')
      }
    })
  })
});

// plugin config
const config = exports.config = {
  deprecations: ({
    rename,
    unused,
    renameFromRoot,
    deprecateFromRoot,
    unusedFromRoot
  }) => [unused('ui.transactionGroupBucketSize', {
    level: 'warning'
  }), rename('autocreateApmIndexPattern', 'autoCreateApmDataView', {
    level: 'warning'
  }), deprecateFromRoot('apm_oss.enabled', '8.0.0', {
    level: 'warning'
  }), unusedFromRoot('apm_oss.fleetMode', {
    level: 'warning'
  }), unusedFromRoot('apm_oss.indexPattern', {
    level: 'warning'
  }), renameFromRoot('xpack.apm.maxServiceEnvironments', `uiSettings.overrides[${_common.maxSuggestions}]`, {
    level: 'warning'
  }), renameFromRoot('xpack.apm.maxServiceSelection', `uiSettings.overrides[${_common.maxSuggestions}]`, {
    level: 'warning'
  }), unused('forceSyntheticSource', {
    level: 'warning'
  })],
  exposeToBrowser: {
    serviceMapEnabled: true,
    ui: true,
    latestAgentVersionsUrl: true,
    managedServiceUrl: true,
    serverlessOnboarding: true,
    featureFlags: true,
    serverless: true
  },
  schema: configSchema
};
const plugin = async initContext => {
  const {
    APMPlugin
  } = await Promise.resolve().then(() => _interopRequireWildcard(require('./plugin')));
  return new APMPlugin(initContext);
};
exports.plugin = plugin;