"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.features = exports.APM_FEATURE = void 0;
exports.notifyFeatureUsage = notifyFeatureUsage;
exports.registerFeaturesUsage = registerFeaturesUsage;
var _i18n = require("@kbn/i18n");
var _server = require("@kbn/core/server");
var _apm_indices = require("@kbn/apm-data-access-plugin/server/saved_objects/apm_indices");
var _ruleDataUtils = require("@kbn/rule-data-utils");
var _common = require("@kbn/features-plugin/common");
var _apm_rule_types = require("../common/rules/apm_rule_types");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ruleTypes = Object.values(_ruleDataUtils.ApmRuleType);
const APM_FEATURE = exports.APM_FEATURE = {
  id: _apm_rule_types.APM_SERVER_FEATURE_ID,
  name: _i18n.i18n.translate('xpack.apm.featureRegistry.apmFeatureName', {
    defaultMessage: 'APM and User Experience'
  }),
  order: 900,
  category: _server.DEFAULT_APP_CATEGORIES.observability,
  scope: [_common.KibanaFeatureScope.Spaces, _common.KibanaFeatureScope.Security],
  app: [_apm_rule_types.APM_SERVER_FEATURE_ID, 'ux', 'kibana'],
  catalogue: [_apm_rule_types.APM_SERVER_FEATURE_ID],
  management: {
    insightsAndAlerting: ['triggersActions']
  },
  alerting: ruleTypes,
  // see x-pack/plugins/features/common/feature_kibana_privileges.ts
  privileges: {
    all: {
      app: [_apm_rule_types.APM_SERVER_FEATURE_ID, 'ux', 'kibana'],
      api: [_apm_rule_types.APM_SERVER_FEATURE_ID, 'apm_write', 'rac'],
      catalogue: [_apm_rule_types.APM_SERVER_FEATURE_ID],
      savedObject: {
        all: [],
        read: [_apm_indices.APM_INDEX_SETTINGS_SAVED_OBJECT_TYPE]
      },
      alerting: {
        alert: {
          all: ruleTypes
        },
        rule: {
          all: ruleTypes
        }
      },
      management: {
        insightsAndAlerting: ['triggersActions']
      },
      ui: ['show', 'save', 'alerting:show', 'alerting:save']
    },
    read: {
      app: [_apm_rule_types.APM_SERVER_FEATURE_ID, 'ux', 'kibana'],
      api: [_apm_rule_types.APM_SERVER_FEATURE_ID, 'rac'],
      catalogue: [_apm_rule_types.APM_SERVER_FEATURE_ID],
      savedObject: {
        all: [],
        read: [_apm_indices.APM_INDEX_SETTINGS_SAVED_OBJECT_TYPE]
      },
      alerting: {
        alert: {
          read: ruleTypes
        },
        rule: {
          read: ruleTypes
        }
      },
      management: {
        insightsAndAlerting: ['triggersActions']
      },
      ui: ['show', 'alerting:show']
    }
  },
  subFeatures: [{
    name: _i18n.i18n.translate('xpack.apm.subFeatureRegistry.settings', {
      defaultMessage: 'Settings'
    }),
    privilegeGroups: [{
      groupType: 'independent',
      privileges: [{
        id: 'settings_save',
        name: _i18n.i18n.translate('xpack.apm.subFeatureRegistry.modifySettings', {
          defaultMessage: 'Ability to modify settings'
        }),
        includeIn: 'all',
        savedObject: {
          all: [],
          read: []
        },
        api: ['apm_settings_write'],
        ui: ['settings:save']
      }]
    }]
  }]
};
const features = exports.features = {
  serviceMaps: {
    name: 'APM service maps',
    license: 'platinum'
  },
  ml: {
    name: 'APM machine learning',
    license: 'platinum'
  },
  customLinks: {
    name: 'APM custom links',
    license: 'gold'
  }
};
function registerFeaturesUsage({
  licensingPlugin
}) {
  Object.values(features).forEach(({
    name,
    license
  }) => {
    licensingPlugin.featureUsage.register(name, license);
  });
}
function notifyFeatureUsage({
  licensingPlugin,
  featureName
}) {
  const feature = features[featureName];
  licensingPlugin.featureUsage.notifyUsage(feature.name);
}