"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TelemetryClient = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _types = require("./types");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class TelemetryClient {
  constructor(analytics) {
    (0, _defineProperty2.default)(this, "reportSearchQuerySubmitted", ({
      kueryFields,
      timerange,
      action
    }) => {
      this.analytics.reportEvent(_types.TelemetryEventTypes.SEARCH_QUERY_SUBMITTED, {
        kueryFields,
        timerange,
        action
      });
    });
    (0, _defineProperty2.default)(this, "reportEntityInventoryAddData", params => {
      this.analytics.reportEvent(_types.TelemetryEventTypes.ENTITY_INVENTORY_ADD_DATA, params);
    });
    (0, _defineProperty2.default)(this, "reportTryItClick", params => {
      this.analytics.reportEvent(_types.TelemetryEventTypes.TRY_IT_CLICK, params);
    });
    (0, _defineProperty2.default)(this, "reportLearnMoreClick", params => {
      this.analytics.reportEvent(_types.TelemetryEventTypes.LEARN_MORE_CLICK, params);
    });
    this.analytics = analytics;
  }
}
exports.TelemetryClient = TelemetryClient;