"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getApmAlertingLatencyChartEmbeddableFactory = void 0;
var _react = _interopRequireDefault(require("react"));
var _presentationPublishing = require("@kbn/presentation-publishing");
var _rxjs = require("rxjs");
var _embeddable_context = require("../../embeddable_context");
var _chart = require("./chart");
var _constants = require("../constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getApmAlertingLatencyChartEmbeddableFactory = deps => {
  const factory = {
    type: _constants.APM_ALERTING_LATENCY_CHART_EMBEDDABLE,
    deserializeState: state => {
      return state.rawState;
    },
    buildEmbeddable: async (state, buildApi, uuid, parentApi) => {
      const {
        titlesApi,
        titleComparators,
        serializeTitles
      } = (0, _presentationPublishing.initializeTitles)(state);
      const serviceName$ = new _rxjs.BehaviorSubject(state.serviceName);
      const transactionType$ = new _rxjs.BehaviorSubject(state.transactionType);
      const transactionName$ = new _rxjs.BehaviorSubject(state.transactionName);
      const environment$ = new _rxjs.BehaviorSubject(state.environment);
      const latencyThresholdInMicroseconds$ = new _rxjs.BehaviorSubject(state.latencyThresholdInMicroseconds);
      const rangeFrom$ = new _rxjs.BehaviorSubject(state.rangeFrom);
      const rangeTo$ = new _rxjs.BehaviorSubject(state.rangeTo);
      const rule$ = new _rxjs.BehaviorSubject(state.rule);
      const alert$ = new _rxjs.BehaviorSubject(state.alert);
      const kuery$ = new _rxjs.BehaviorSubject(state.kuery);
      const filters$ = new _rxjs.BehaviorSubject(state.filters);
      const api = buildApi({
        ...titlesApi,
        serializeState: () => {
          return {
            rawState: {
              ...serializeTitles(),
              serviceName: serviceName$.getValue(),
              transactionType: transactionType$.getValue(),
              transactionName: transactionName$.getValue(),
              environment: environment$.getValue(),
              latencyThresholdInMicroseconds: latencyThresholdInMicroseconds$.getValue(),
              rangeFrom: rangeFrom$.getValue(),
              rangeTo: rangeTo$.getValue(),
              rule: rule$.getValue(),
              alert: alert$.getValue(),
              kuery: kuery$.getValue(),
              filters: filters$.getValue()
            }
          };
        }
      }, {
        serviceName: [serviceName$, value => serviceName$.next(value)],
        transactionType: [transactionType$, value => transactionType$.next(value)],
        transactionName: [transactionName$, value => transactionName$.next(value)],
        environment: [environment$, value => environment$.next(value)],
        latencyThresholdInMicroseconds: [latencyThresholdInMicroseconds$, value => latencyThresholdInMicroseconds$.next(value)],
        rangeFrom: [rangeFrom$, value => rangeFrom$.next(value)],
        rangeTo: [rangeTo$, value => rangeTo$.next(value)],
        rule: [rule$, value => rule$.next(value)],
        alert: [alert$, value => alert$.next(value)],
        kuery: [kuery$, value => kuery$.next(value)],
        filters: [filters$, value => filters$.next(value)],
        ...titleComparators
      });
      return {
        api,
        Component: () => {
          const [serviceName, transactionType, transactionName, environment, latencyThresholdInMicroseconds, rangeFrom, rangeTo, rule, alert, kuery, filters] = (0, _presentationPublishing.useBatchedPublishingSubjects)(serviceName$, transactionType$, transactionName$, environment$, latencyThresholdInMicroseconds$, rangeFrom$, rangeTo$, rule$, alert$, kuery$, filters$);
          return /*#__PURE__*/_react.default.createElement(_embeddable_context.ApmEmbeddableContext, {
            deps: deps,
            rangeFrom: rangeFrom,
            rangeTo: rangeTo
          }, /*#__PURE__*/_react.default.createElement(_chart.APMAlertingLatencyChart, {
            rule: rule,
            alert: alert,
            latencyThresholdInMicroseconds: latencyThresholdInMicroseconds,
            serviceName: serviceName,
            transactionType: transactionType,
            environment: environment,
            rangeFrom: rangeFrom,
            rangeTo: rangeTo,
            transactionName: transactionName,
            kuery: kuery,
            filters: filters
          }));
        }
      };
    }
  };
  return factory;
};
exports.getApmAlertingLatencyChartEmbeddableFactory = getApmAlertingLatencyChartEmbeddableFactory;