"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TableSearchBar = TableSearchBar;
exports.getItemsFilteredBySearchQuery = getItemsFilteredBySearchQuery;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _react2 = require("@emotion/react");
var _technical_preview_badge = require("../technical_preview_badge");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function TableSearchBar({
  placeholder,
  searchQuery,
  onChangeSearchQuery,
  techPreview = false
}) {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s"
  }, techPreview ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    css: (0, _react2.css)`
            justify-content: center;
          `
  }, /*#__PURE__*/_react.default.createElement(_technical_preview_badge.TechnicalPreviewBadge, {
    icon: "beaker"
  })) : null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldSearch, {
    "data-test-subj": "tableSearchInput",
    placeholder: placeholder,
    fullWidth: true,
    value: searchQuery,
    onChange: e => {
      onChangeSearchQuery(e.target.value);
    }
  })));
}
function getItemsFilteredBySearchQuery({
  items,
  fieldsToSearch,
  searchQuery
}) {
  return items.filter(item => {
    return fieldsToSearch.some(field => {
      const fieldValue = item[field];
      return fieldValue === null || fieldValue === void 0 ? void 0 : fieldValue.toLowerCase().includes(searchQuery.toLowerCase());
    });
  });
}