"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Variables = Variables;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
var _common = require("@kbn/kibana-react-plugin/common");
var _key_value_table = require("../key_value_table");
var _flatten_object = require("../../../../common/utils/flatten_object");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const VariablesContainer = _common.euiStyled.div`
  background: ${({
  theme
}) => theme.eui.euiColorEmptyShade};
  border-radius: 0 0 ${({
  theme
}) => `${theme.eui.euiBorderRadiusSmall} ${theme.eui.euiBorderRadiusSmall}`};
  padding:  ${({
  theme
}) => `${theme.eui.euiSizeS} ${theme.eui.euiSizeM}`};
`;
function Variables({
  vars
}) {
  if (!vars) {
    return null;
  }
  const flattenedVariables = (0, _flatten_object.flattenObject)(vars);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(VariablesContainer, null, /*#__PURE__*/_react.default.createElement(_eui.EuiAccordion, {
    id: "local-variables",
    className: "euiAccordion",
    buttonContent: _i18n.i18n.translate('xpack.apm.stacktraceTab.localVariablesToogleButtonLabel', {
      defaultMessage: 'Local variables'
    })
  }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_key_value_table.KeyValueTable, {
    keyValuePairs: flattenedVariables
  })))));
}