"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.IconPopover = IconPopover;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _use_fetcher = require("../../../hooks/use_fetcher");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function IconPopover({
  icon,
  title,
  children,
  onClick,
  onClose,
  detailsFetchStatus,
  isOpen
}) {
  var _icon$size;
  if (!icon.type) {
    return null;
  }
  const isLoading = detailsFetchStatus === _use_fetcher.FETCH_STATUS.LOADING;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    anchorPosition: "downCenter",
    ownFocus: false,
    button: /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
      display: "base",
      color: "text",
      onClick: onClick,
      iconType: icon.type,
      iconSize: (_icon$size = icon.size) !== null && _icon$size !== void 0 ? _icon$size : 'l',
      className: "serviceIcon_button",
      "data-test-subj": `popover_${title}`,
      size: "m"
    }),
    isOpen: isOpen,
    closePopover: onClose
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPopoverTitle, null, title), /*#__PURE__*/_react.default.createElement("div", {
    style: {
      minWidth: 300
    }
  }, isLoading ? /*#__PURE__*/_react.default.createElement(_eui.EuiSkeletonText, {
    "data-test-subj": "loading-content"
  }) : children));
}