"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.KeyValueFilterList = KeyValueFilterList;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireWildcard(require("react"));
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _lodash = require("lodash");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const StyledEuiAccordion = (0, _styledComponents.default)(_eui.EuiAccordion)`
  width: 100%;
  .buttonContentContainer .euiIEFlexWrapFix {
    width: 100%;
  }
`;
const StyledEuiDescriptionList = (0, _styledComponents.default)(_eui.EuiDescriptionList)`
  margin: ${({
  theme
}) => `${theme.eui.euiSizeS} ${theme.eui.euiSizeS} 0 ${theme.eui.euiSizeS}`};
  .descriptionList__title,
  .descriptionList__description {
    margin-top: 0;
    align-items: center;
    display: flex;
`;
function removeEmptyValues(items) {
  return items.filter(({
    value
  }) => !(0, _lodash.isEmpty)(value));
}
function KeyValueFilterList({
  icon,
  title,
  keyValueList,
  initialIsOpen = false,
  onClickFilter
}) {
  const nonEmptyKeyValueList = removeEmptyValues(keyValueList);
  if (!nonEmptyKeyValueList.length) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(StyledEuiAccordion, {
    initialIsOpen: initialIsOpen,
    id: title,
    buttonContent: /*#__PURE__*/_react.default.createElement(AccordionButtonContent, {
      icon: icon,
      title: title
    }),
    buttonClassName: "buttonContentContainer"
  }, /*#__PURE__*/_react.default.createElement(StyledEuiDescriptionList, {
    type: "column",
    columnWidths: ['20%', '80%']
  }, nonEmptyKeyValueList.map(({
    key,
    value,
    isFilterable
  }) => {
    return /*#__PURE__*/_react.default.createElement(_react.Fragment, {
      key: key
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListTitle, {
      className: "descriptionList__title",
      style: {
        height: '40px'
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s",
      style: {
        fontWeight: 'bold'
      }
    }, key)), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListDescription, {
      className: "descriptionList__description",
      style: {
        height: '40px'
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      alignItems: "baseline",
      responsive: false,
      gutterSize: "none"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      style: {
        minWidth: '32px'
      },
      grow: false
    }, isFilterable && /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      onClick: () => {
        onClickFilter({
          key,
          value
        });
      },
      "data-test-subj": `filter_by_${key}`
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      position: "top",
      content: _i18n.i18n.translate('xpack.apm.keyValueFilterList.actionFilterLabel', {
        defaultMessage: 'Filter by value'
      })
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: "filter",
      color: "text",
      size: "m"
    })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s"
    }, value)))));
  })));
}
function AccordionButtonContent({
  icon,
  title
}) {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    responsive: false,
    gutterSize: "s"
  }, icon && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: icon,
    size: "l",
    title: title,
    "data-test-subj": "accordion_title_icon"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, title)));
}