"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DependenciesTable = DependenciesTable;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
var _use_breakpoints = require("../../../hooks/use_breakpoints");
var _use_fetcher = require("../../../hooks/use_fetcher");
var _empty_message = require("../empty_message");
var _managed_table = require("../managed_table");
var _overview_table_container = require("../overview_table_container");
var _truncate_with_tooltip = require("../truncate_with_tooltip");
var _get_span_metric_columns = require("./get_span_metric_columns");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function DependenciesTable(props) {
  const {
    dependencies,
    fixedHeight,
    link,
    title,
    nameColumnTitle,
    status,
    compact = true,
    showPerPageOptions = true,
    initialPageSize,
    showSparkPlots
  } = props;
  const {
    isLarge
  } = (0, _use_breakpoints.useBreakpoints)();
  const shouldShowSparkPlots = showSparkPlots !== null && showSparkPlots !== void 0 ? showSparkPlots : !isLarge;
  const items = dependencies.map(dependency => ({
    name: dependency.name,
    link: dependency.link,
    latency: dependency.currentStats.latency.value,
    throughput: dependency.currentStats.throughput.value,
    failureRate: dependency.currentStats.errorRate.value,
    impact: dependency.currentStats.impact,
    currentStats: {
      latency: dependency.currentStats.latency.timeseries,
      throughput: dependency.currentStats.throughput.timeseries,
      failureRate: dependency.currentStats.errorRate.timeseries
    },
    previousStats: dependency.previousStats ? {
      latency: dependency.previousStats.latency.timeseries,
      throughput: dependency.previousStats.throughput.timeseries,
      failureRate: dependency.previousStats.errorRate.timeseries,
      impact: dependency.previousStats.impact
    } : undefined
  }));
  const columns = [{
    field: 'name',
    name: nameColumnTitle,
    render: (_, item) => {
      const {
        name,
        link: itemLink
      } = item;
      return /*#__PURE__*/_react.default.createElement(_truncate_with_tooltip.TruncateWithTooltip, {
        text: name,
        content: itemLink
      });
    },
    sortable: true,
    width: '30%'
  }, ...(0, _get_span_metric_columns.getSpanMetricColumns)({
    shouldShowSparkPlots,
    comparisonFetchStatus: status
  })];
  const noItemsMessage = !compact ? /*#__PURE__*/_react.default.createElement(_empty_message.EmptyMessage, {
    heading: _i18n.i18n.translate('xpack.apm.dependenciesTable.notFoundLabel', {
      defaultMessage: 'No dependencies found'
    })
  }) : _i18n.i18n.translate('xpack.apm.dependenciesTable.notFoundLabel', {
    defaultMessage: 'No dependencies found'
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "s",
    "data-test-subj": "dependenciesTable"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    responsive: false,
    justifyContent: "spaceBetween"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement("h2", null, title))), link && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, link))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_overview_table_container.OverviewTableContainer, {
    fixedHeight: fixedHeight,
    isEmptyAndNotInitiated: items.length === 0 && status === _use_fetcher.FETCH_STATUS.NOT_INITIATED
  }, /*#__PURE__*/_react.default.createElement(_managed_table.ManagedTable, {
    isLoading: status === _use_fetcher.FETCH_STATUS.LOADING,
    error: status === _use_fetcher.FETCH_STATUS.FAILURE,
    columns: columns,
    items: items,
    noItemsMessage: noItemsMessage,
    initialSortField: "impact",
    initialSortDirection: "desc",
    pagination: true,
    showPerPageOptions: showPerPageOptions,
    initialPageSize: initialPageSize
  }))));
}