"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ApmMainTemplate = ApmMainTemplate;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _eui = require("@elastic/eui");
var _public = require("@kbn/kibana-react-plugin/public");
var _react = _interopRequireWildcard(require("react"));
var _reactRouterDom = require("react-router-dom");
var _public2 = require("@kbn/observability-shared-plugin/public");
var _use_apm_service_context = require("../../../../context/apm_service/use_apm_service_context");
var _get_signal_type = require("../../../../utils/get_signal_type");
var _use_local_storage = require("../../../../hooks/use_local_storage");
var _use_default_ai_assistant_starter_prompts_for_apm = require("../../../../hooks/use_default_ai_assistant_starter_prompts_for_apm");
var _kibana_environment_context = require("../../../../context/kibana_environment_context/kibana_environment_context");
var _get_path_for_feedback = require("../../../../utils/get_path_for_feedback");
var _environments_context = require("../../../../context/environments_context/environments_context");
var _use_fetcher = require("../../../../hooks/use_fetcher");
var _service_groups = require("../../../app/service_groups");
var _service_groups_button_group = require("../../../app/service_groups/service_groups_button_group");
var _environment_filter = require("../../../shared/environment_filter");
var _no_data_config = require("../no_data_config");
var _use_apm_plugin_context = require("../../../../context/apm_plugin/use_apm_plugin_context");
var _entities_inventory_callout = require("./entities_inventory_callout");
var _use_entity_centric_experience_setting = require("../../../../hooks/use_entity_centric_experience_setting");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// Paths that must skip the no data screen
const bypassNoDataScreenPaths = ['/settings', '/diagnostics'];
const APM_FEEDBACK_LINK = 'https://ela.st/services-feedback';
const APM_NEW_EXPERIENCE_FEEDBACK_LINK = 'https://ela.st/entity-services-feedback';

/*
 * This template contains:
 *  - The Shared Observability Nav (https://github.com/elastic/kibana/blob/f7698bd8aa8787d683c728300ba4ca52b202369c/x-pack/plugins/observability/public/components/shared/page_template/README.md)
 *  - The APM Header Action Menu
 *  - Page title
 *
 *  Optionally:
 *   - EnvironmentFilter
 *   - ServiceGroupSaveButton
 */
function ApmMainTemplate({
  pageTitle,
  pageHeader,
  children,
  environmentFilter = true,
  showServiceGroupSaveButton = false,
  showServiceGroupsNav = false,
  showEnablementCallout = false,
  selectedNavButton,
  ...pageTemplateProps
}) {
  var _serviceEntitySummary, _pageHeader$pageTitle;
  const location = (0, _reactRouterDom.useLocation)();
  const {
    services
  } = (0, _public.useKibana)();
  const kibanaEnvironment = (0, _react.useContext)(_kibana_environment_context.KibanaEnvironmentContext);
  const {
    http,
    docLinks,
    observabilityShared,
    application
  } = services;
  const {
    kibanaVersion,
    isCloudEnv,
    isServerlessEnv
  } = kibanaEnvironment;
  const basePath = http === null || http === void 0 ? void 0 : http.basePath.get();
  const {
    config
  } = (0, _use_apm_plugin_context.useApmPluginContext)();
  const {
    serviceEntitySummary
  } = (0, _use_apm_service_context.useApmServiceContext)();
  const {
    isEntityCentricExperienceEnabled
  } = (0, _use_entity_centric_experience_setting.useEntityCentricExperienceSetting)();
  const ObservabilityPageTemplate = observabilityShared.navigation.PageTemplate;
  const {
    data,
    status
  } = (0, _use_fetcher.useFetcher)(callApmApi => {
    return callApmApi('GET /internal/apm/has_data');
  }, []);

  // create static data view on initial load
  (0, _use_fetcher.useFetcher)(callApmApi => {
    const canCreateDataView = application === null || application === void 0 ? void 0 : application.capabilities.savedObjectsManagement.edit;
    if (canCreateDataView) {
      return callApmApi('POST /internal/apm/data_view/static');
    }
  }, [application === null || application === void 0 ? void 0 : application.capabilities.savedObjectsManagement.edit]);
  const hasLogsData = serviceEntitySummary !== null && serviceEntitySummary !== void 0 && serviceEntitySummary.dataStreamTypes ? (serviceEntitySummary === null || serviceEntitySummary === void 0 ? void 0 : (_serviceEntitySummary = serviceEntitySummary.dataStreamTypes) === null || _serviceEntitySummary === void 0 ? void 0 : _serviceEntitySummary.length) > 0 && (0, _get_signal_type.isLogsSignal)(serviceEntitySummary.dataStreamTypes) : false;
  const shouldBypassNoDataScreen = bypassNoDataScreenPaths.some(path => location.pathname.includes(path)) || isEntityCentricExperienceEnabled && hasLogsData;
  const {
    data: fleetApmPoliciesData,
    status: fleetApmPoliciesStatus
  } = (0, _use_fetcher.useFetcher)(callApmApi => {
    if (!(data !== null && data !== void 0 && data.hasData) && !shouldBypassNoDataScreen) {
      return callApmApi('GET /internal/apm/fleet/has_apm_policies');
    }
  }, [shouldBypassNoDataScreen, data === null || data === void 0 ? void 0 : data.hasData]);
  const isLoading = status === _use_fetcher.FETCH_STATUS.LOADING || fleetApmPoliciesStatus === _use_fetcher.FETCH_STATUS.LOADING;
  const hasApmData = !!(data !== null && data !== void 0 && data.hasData);
  const hasApmIntegrations = !!(fleetApmPoliciesData !== null && fleetApmPoliciesData !== void 0 && fleetApmPoliciesData.hasApmPolicies);
  const noDataConfig = (0, _no_data_config.getNoDataConfig)({
    basePath,
    docsLink: docLinks.links.observability.guide,
    hasApmData,
    hasApmIntegrations,
    shouldBypassNoDataScreen,
    loading: isLoading,
    isServerless: config === null || config === void 0 ? void 0 : config.serverlessOnboarding
  });
  (0, _use_default_ai_assistant_starter_prompts_for_apm.useDefaultAiAssistantStarterPromptsForAPM)({
    hasApmData,
    hasApmIntegrations,
    noDataConfig
  });
  const sanitizedPath = (0, _get_path_for_feedback.getPathForFeedback)(window.location.pathname);
  const rightSideItems = [...(showServiceGroupSaveButton ? [/*#__PURE__*/_react.default.createElement(_service_groups.ServiceGroupSaveButton, null)] : []), ...(environmentFilter ? [/*#__PURE__*/_react.default.createElement(_environment_filter.ApmEnvironmentFilter, null)] : []), /*#__PURE__*/_react.default.createElement(_public2.FeatureFeedbackButton, {
    "data-test-subj": "infraApmFeedbackLink",
    formUrl: isEntityCentricExperienceEnabled && sanitizedPath.includes('service') ? APM_NEW_EXPERIENCE_FEEDBACK_LINK : APM_FEEDBACK_LINK,
    kibanaVersion: kibanaVersion,
    isCloudEnv: isCloudEnv,
    isServerlessEnv: isServerlessEnv,
    sanitizedPath: sanitizedPath
  })];
  const [dismissedEntitiesInventoryCallout, setdismissedEntitiesInventoryCallout] = (0, _use_local_storage.useLocalStorage)(`apm.dismissedEntitiesInventoryCallout`, false);
  const showEntitiesInventoryCallout = !dismissedEntitiesInventoryCallout && isEntityCentricExperienceEnabled && selectedNavButton !== undefined;
  return /*#__PURE__*/_react.default.createElement(_environments_context.EnvironmentsContextProvider, null, /*#__PURE__*/_react.default.createElement(ObservabilityPageTemplate, (0, _extends2.default)({
    noDataConfig: shouldBypassNoDataScreen ? undefined : noDataConfig,
    isPageDataLoaded: isLoading === false,
    pageHeader: {
      rightSideItems,
      ...pageHeader,
      pageTitle: (_pageHeader$pageTitle = pageHeader === null || pageHeader === void 0 ? void 0 : pageHeader.pageTitle) !== null && _pageHeader$pageTitle !== void 0 ? _pageHeader$pageTitle : pageTitle,
      children: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
        direction: "column"
      }, showEntitiesInventoryCallout ? /*#__PURE__*/_react.default.createElement(_entities_inventory_callout.EntitiesInventoryCallout, {
        onDismiss: () => {
          setdismissedEntitiesInventoryCallout(true);
        }
      }) : null, showServiceGroupsNav && selectedNavButton && /*#__PURE__*/_react.default.createElement(_service_groups_button_group.ServiceGroupsButtonGroup, {
        selectedNavButton: selectedNavButton
      }))
    }
  }, pageTemplateProps), children));
}