"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EntitiesInventoryCallout = EntitiesInventoryCallout;
var _eui = require("@elastic/eui");
var _public = require("@kbn/observability-shared-plugin/public");
var _react = _interopRequireDefault(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _public2 = require("@kbn/kibana-react-plugin/public");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function EntitiesInventoryCallout({
  onDismiss
}) {
  const {
    services
  } = (0, _public2.useKibana)();
  const {
    observabilityShared
  } = services;
  const entitiesInventoryLocator = observabilityShared.locators.entitiesInventory;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    alignItems: "center",
    gutterSize: "xs"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_public.TechnicalPreviewBadge, {
    icon: "beaker",
    style: {
      verticalAlign: 'middle'
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    "data-test-subj": "apmEntitiesInventoryCalloutLink",
    href: entitiesInventoryLocator.useUrl({})
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.apm.entitiesInventoryCallout.linklabel",
    defaultMessage: "Try our new Inventory!"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.apm.entitiesInventoryCallout.linkTooltip",
      defaultMessage: "Hide this"
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    "data-test-subj": "apmEntitiesInventoryCalloutDismiss",
    iconType: "cross",
    onClick: onDismiss
  }))));
}