"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Waterfall = Waterfall;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireWildcard(require("react"));
var _reactRouterDom = require("react-router-dom");
var _common = require("@kbn/kibana-react-plugin/common");
var _react2 = require("@emotion/react");
var _use_theme = require("../../../../../../hooks/use_theme");
var _timeline = require("../../../../../shared/charts/timeline");
var _url_helpers = require("../../../../../shared/links/url_helpers");
var _get_agent_marks = require("../marks/get_agent_marks");
var _get_error_marks = require("../marks/get_error_marks");
var _accordion_waterfall = require("./accordion_waterfall");
var _waterfall_flyout = require("./waterfall_flyout");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const Container = _common.euiStyled.div`
  transition: 0.1s padding ease;
  position: relative;
`;
const toggleFlyout = ({
  history,
  item,
  flyoutDetailTab
}) => {
  history.replace({
    ...history.location,
    search: (0, _url_helpers.fromQuery)({
      ...(0, _url_helpers.toQuery)(location.search),
      flyoutDetailTab,
      waterfallItemId: item === null || item === void 0 ? void 0 : item.id
    })
  });
};
const WaterfallItemsContainer = _common.euiStyled.div`
  border-bottom: 1px solid ${({
  theme
}) => theme.eui.euiColorMediumShade};
`;
function getWaterfallMaxLevel(waterfall) {
  var _waterfall$entryWater;
  const entryId = (_waterfall$entryWater = waterfall.entryWaterfallTransaction) === null || _waterfall$entryWater === void 0 ? void 0 : _waterfall$entryWater.id;
  if (!entryId) {
    return 0;
  }
  let maxLevel = 1;
  const visited = new Set();
  const queue = [{
    id: entryId,
    level: 1
  }];
  while (queue.length > 0) {
    const {
      id,
      level
    } = queue.shift();
    const children = waterfall.childrenByParentId[id] || [];
    maxLevel = Math.max(maxLevel, level);
    visited.add(id);
    children.forEach(child => {
      if (child.id !== id && !visited.has(child.id)) {
        queue.push({
          id: child.id,
          level: level + 1
        });
        visited.add(child.id);
      }
    });
  }
  return maxLevel;
}
const MAX_DEPTH_OPEN_LIMIT = 2;
function Waterfall({
  waterfall,
  waterfallItemId,
  showCriticalPath
}) {
  const history = (0, _reactRouterDom.useHistory)();
  const theme = (0, _use_theme.useTheme)();
  const [isAccordionOpen, setIsAccordionOpen] = (0, _react.useState)(true);
  const {
    duration
  } = waterfall;
  const agentMarks = (0, _get_agent_marks.getAgentMarks)(waterfall.entryTransaction);
  const errorMarks = (0, _get_error_marks.getErrorMarks)(waterfall.errorItems);
  const timelineMargins = (0, _react.useMemo)(() => {
    // Calculate the left margin relative to the deepest level, or 100px, whichever
    // is more.
    const maxLevel = getWaterfallMaxLevel(waterfall);
    return {
      top: 40,
      left: Math.max(100, maxLevel * 10),
      right: 50,
      bottom: 0
    };
  }, [waterfall]);
  return /*#__PURE__*/_react.default.createElement(Container, null, waterfall.exceedsMax && /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    "data-test-subj": "apmWaterfallSizeWarning",
    color: "warning",
    size: "s",
    iconType: "warning",
    title: _i18n.i18n.translate('xpack.apm.waterfall.exceedsMax', {
      defaultMessage: 'The number of items in this trace is {traceDocsTotal} which is higher than the current limit of {maxTraceItems}. Please increase the limit via `xpack.apm.ui.maxTraceItems` to see the full trace',
      values: {
        traceDocsTotal: waterfall.traceDocsTotal,
        maxTraceItems: waterfall.maxTraceItems
      }
    })
  }), /*#__PURE__*/_react.default.createElement("div", {
    css: (0, _react2.css)`
          display: flex;
          position: sticky;
          top: var(--euiFixedHeadersOffset, 0);
          z-index: ${theme.eui.euiZLevel2};
          background-color: ${theme.eui.euiColorEmptyShade};
          border-bottom: 1px solid ${theme.eui.euiColorMediumShade};
        `
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": "apmWaterfallButton",
    css: (0, _react2.css)`
            position: absolute;
            z-index: ${theme.eui.euiZLevel2};
          `,
    iconType: isAccordionOpen ? 'fold' : 'unfold',
    onClick: () => {
      setIsAccordionOpen(isOpen => !isOpen);
    }
  }), /*#__PURE__*/_react.default.createElement(_timeline.TimelineAxisContainer, {
    marks: [...agentMarks, ...errorMarks],
    xMax: duration,
    margins: timelineMargins
  })), /*#__PURE__*/_react.default.createElement(_timeline.VerticalLinesContainer, {
    marks: [...agentMarks, ...errorMarks],
    xMax: duration,
    margins: timelineMargins
  }), /*#__PURE__*/_react.default.createElement(WaterfallItemsContainer, null, !waterfall.entryWaterfallTransaction ? null : /*#__PURE__*/_react.default.createElement(_accordion_waterfall.AccordionWaterfall, {
    isOpen: isAccordionOpen,
    waterfallItemId: waterfallItemId,
    duration: duration,
    waterfall: waterfall,
    timelineMargins: timelineMargins,
    onClickWaterfallItem: (item, flyoutDetailTab) => toggleFlyout({
      history,
      item,
      flyoutDetailTab
    }),
    showCriticalPath: showCriticalPath,
    maxLevelOpen: waterfall.traceDocsTotal > 500 ? MAX_DEPTH_OPEN_LIMIT : waterfall.traceDocsTotal
  })), /*#__PURE__*/_react.default.createElement(_waterfall_flyout.WaterfallFlyout, {
    waterfallItemId: waterfallItemId,
    waterfall: waterfall,
    toggleFlyout: toggleFlyout
  }));
}