"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FiltersSection = FiltersSection;
var _moment = _interopRequireDefault(require("moment"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _lodash = require("lodash");
var _react = _interopRequireDefault(require("react"));
var _helper = require("./helper");
var _suggestions_select = require("../../../../shared/suggestions_select");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function FiltersSection({
  filters,
  onChangeFilters
}) {
  const onChangeFilter = (key, value, idx) => {
    const newFilters = [...filters];
    newFilters[idx] = {
      key,
      value
    };
    onChangeFilters(newFilters);
  };
  const onRemoveFilter = idx => {
    // remove without mutating original array
    const newFilters = [...filters];
    newFilters.splice(idx, 1);

    // if there is only one item left it should not be removed
    // but reset to empty
    if ((0, _lodash.isEmpty)(newFilters)) {
      onChangeFilters([{
        key: '',
        value: ''
      }]);
    } else {
      onChangeFilters(newFilters);
    }
  };
  const handleAddFilter = () => {
    onChangeFilters([...filters, {
      key: '',
      value: ''
    }]);
  };
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement("h3", null, _i18n.i18n.translate('xpack.apm.settings.customLink.flyout.filters.title', {
    defaultMessage: 'Filters'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, _i18n.i18n.translate('xpack.apm.settings.customLink.flyout.filters.subtitle', {
    defaultMessage: 'Use the filter options to scope them to only appear for specific services.'
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), filters.map((filter, idx) => {
    const {
      key,
      value
    } = filter;
    const filterId = `filter-${idx}`;
    const selectOptions = (0, _helper.getSelectOptions)(filters, key);
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, {
      key: filterId
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      gutterSize: "s",
      alignItems: "center"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
      "data-test-subj": filterId,
      id: filterId,
      fullWidth: true,
      options: selectOptions,
      value: key,
      prepend: _i18n.i18n.translate('xpack.apm.settings.customLink.flyout.filters.prepend', {
        defaultMessage: 'Field'
      }),
      onChange: e =>
      // set value to empty string to reset value when new field is selected
      onChangeFilter(e.target.value, '', idx),
      isInvalid: !(0, _lodash.isEmpty)(value) && ((0, _lodash.isEmpty)(key) || key === _helper.DEFAULT_OPTION.value)
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_suggestions_select.SuggestionsSelect, {
      key: key,
      dataTestSubj: `${key}.value`,
      fieldName: key,
      placeholder: _i18n.i18n.translate('xpack.apm.settings.customLink.flyOut.filters.defaultOption.value', {
        defaultMessage: 'Value'
      }),
      onChange: selectedValue => onChangeFilter(key, selectedValue, idx),
      defaultValue: value,
      isInvalid: !(0, _lodash.isEmpty)(key) && (0, _lodash.isEmpty)(value),
      start: (0, _moment.default)().subtract(24, 'h').toISOString(),
      end: (0, _moment.default)().toISOString()
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      "data-test-subj": "apmCustomLinkFiltersSectionButton",
      iconType: "trash",
      onClick: () => onRemoveFilter(idx),
      disabled: !value && !key && filters.length === 1
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "s"
    }));
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xs"
  }), /*#__PURE__*/_react.default.createElement(AddFilterButton, {
    onClick: handleAddFilter
    // Disable button when user has already added all items available
    ,
    isDisabled: filters.length === _helper.FILTER_SELECT_OPTIONS.length - 1
  }));
}
function AddFilterButton({
  onClick,
  isDisabled
}) {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": "apmCustomLinkAddFilterButtonAddAnotherFilterButton",
    iconType: "plusInCircle",
    onClick: onClick,
    disabled: isDisabled
  }, _i18n.i18n.translate('xpack.apm.settings.customLink.flyout.filters.addAnotherFilter', {
    defaultMessage: 'Add another filter'
  }));
}