"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ServiceOverview = ServiceOverview;
exports.chartHeight = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _annotations_context = require("../../../context/annotations/annotations_context");
var _use_apm_plugin_context = require("../../../context/apm_plugin/use_apm_plugin_context");
var _use_apm_service_context = require("../../../context/apm_service/use_apm_service_context");
var _chart_pointer_event_context = require("../../../context/chart_pointer_event/chart_pointer_event_context");
var _use_apm_params = require("../../../hooks/use_apm_params");
var _use_time_range = require("../../../hooks/use_time_range");
var _get_signal_type = require("../../../utils/get_signal_type");
var _apm_overview = require("./apm_overview");
var _logs_overview = require("./logs_overview");
var _service_tab_empty_state = require("../service_tab_empty_state");
var _use_local_storage = require("../../../hooks/use_local_storage");
var _search_bar = require("../../shared/search_bar/search_bar");
var _use_fetcher = require("../../../hooks/use_fetcher");
var _use_entity_centric_experience_setting = require("../../../hooks/use_entity_centric_experience_setting");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * The height a chart should be if it's next to a table with 5 rows and a title.
 * Add the height of the pagination row.
 */
const chartHeight = exports.chartHeight = 288;
function ServiceOverview() {
  var _useApmPluginContext$, _serviceEntitySummary;
  const {
    isEntityCentricExperienceEnabled
  } = (0, _use_entity_centric_experience_setting.useEntityCentricExperienceSetting)();
  const {
    serviceName,
    serviceEntitySummary,
    serviceEntitySummaryStatus
  } = (0, _use_apm_service_context.useApmServiceContext)();
  const setScreenContext = (_useApmPluginContext$ = (0, _use_apm_plugin_context.useApmPluginContext)().observabilityAIAssistant) === null || _useApmPluginContext$ === void 0 ? void 0 : _useApmPluginContext$.service.setScreenContext;
  (0, _react.useEffect)(() => {
    return setScreenContext === null || setScreenContext === void 0 ? void 0 : setScreenContext({
      screenDescription: `The user is looking at the service overview page for ${serviceName}.`,
      data: [{
        name: 'service_name',
        description: 'The name of the service',
        value: serviceName
      }]
    });
  }, [setScreenContext, serviceName]);
  const {
    query: {
      environment,
      rangeFrom,
      rangeTo
    }
  } = (0, _use_apm_params.useApmParams)('/services/{serviceName}/overview');
  const {
    start,
    end
  } = (0, _use_time_range.useTimeRange)({
    rangeFrom,
    rangeTo
  });
  const [dismissedLogsOnlyEmptyState, setDismissedLogsOnlyEmptyState] = (0, _use_local_storage.useLocalStorage)(`apm.dismissedLogsOnlyEmptyState.overview`, false);
  const hasSignal = (serviceEntitySummary === null || serviceEntitySummary === void 0 ? void 0 : serviceEntitySummary.dataStreamTypes) && (serviceEntitySummary === null || serviceEntitySummary === void 0 ? void 0 : (_serviceEntitySummary = serviceEntitySummary.dataStreamTypes) === null || _serviceEntitySummary === void 0 ? void 0 : _serviceEntitySummary.length) > 0;
  const hasLogsOnlySignal = hasSignal && (0, _get_signal_type.isLogsOnlySignal)(serviceEntitySummary.dataStreamTypes);
  const hasLogsSignal = hasSignal && (0, _get_signal_type.isLogsSignal)(serviceEntitySummary.dataStreamTypes);

  // Shows APM overview when entity has APM signal or when Entity centric is not enabled
  const hasApmSignal = hasSignal && (0, _get_signal_type.isApmSignal)(serviceEntitySummary.dataStreamTypes);

  // Shows APM overview when entity has APM signal or when Entity centric is not enabled or when entity has no signal
  const showApmOverview = isEntityCentricExperienceEnabled === false || hasApmSignal || !hasSignal;
  if (serviceEntitySummaryStatus === _use_fetcher.FETCH_STATUS.LOADING) {
    return /*#__PURE__*/_react.default.createElement("div", {
      style: {
        textAlign: 'center'
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingLogo, {
      logo: "logoObservability",
      size: "l"
    }));
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_search_bar.SearchBar, {
    showTimeComparison: true,
    showTransactionTypeSelector: true
  }), /*#__PURE__*/_react.default.createElement(_annotations_context.AnnotationsContextProvider, {
    serviceName: serviceName,
    environment: environment,
    start: start,
    end: end
  }, /*#__PURE__*/_react.default.createElement(_chart_pointer_event_context.ChartPointerEventContextProvider, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "s"
  }, showApmOverview ? /*#__PURE__*/_react.default.createElement(_apm_overview.ApmOverview, null) : null, hasLogsSignal ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, hasLogsOnlySignal && !dismissedLogsOnlyEmptyState && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_service_tab_empty_state.ServiceTabEmptyState, {
    id: "serviceOverview",
    onDismiss: () => setDismissedLogsOnlyEmptyState(true)
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_logs_overview.LogsOverview, null))) : null))));
}