"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ServiceDependencies = ServiceDependencies;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
var _get_signal_type = require("../../../utils/get_signal_type");
var _chart_pointer_event_context = require("../../../context/chart_pointer_event/chart_pointer_event_context");
var _service_overview_dependencies_table = require("../service_overview/service_overview_dependencies_table");
var _service_dependencies_breakdown_chart = require("./service_dependencies_breakdown_chart");
var _use_apm_service_context = require("../../../context/apm_service/use_apm_service_context");
var _service_tab_empty_state = require("../service_tab_empty_state");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function ServiceDependencies() {
  const {
    serviceEntitySummary
  } = (0, _use_apm_service_context.useApmServiceContext)();
  const hasLogsOnlySignal = (serviceEntitySummary === null || serviceEntitySummary === void 0 ? void 0 : serviceEntitySummary.dataStreamTypes) && (0, _get_signal_type.isLogsOnlySignal)(serviceEntitySummary.dataStreamTypes);
  if (hasLogsOnlySignal) {
    return /*#__PURE__*/_react.default.createElement(_service_tab_empty_state.ServiceTabEmptyState, {
      id: "serviceDependencies"
    });
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_chart_pointer_event_context.ChartPointerEventContextProvider, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement("h2", null, _i18n.i18n.translate('xpack.apm.serviceDependencies.breakdownChartTitle', {
    defaultMessage: 'Time spent by dependency'
  }))), /*#__PURE__*/_react.default.createElement(_service_dependencies_breakdown_chart.ServiceDependenciesBreakdownChart, {
    height: 200
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }), /*#__PURE__*/_react.default.createElement(_service_overview_dependencies_table.ServiceOverviewDependenciesTable, null));
}