"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createPhpAgentInstructions = void 0;
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _agent_config_instructions = require("../agent_config_instructions");
var _instruction_variants = require("../instruction_variants");
var _api_key_callout = require("./api_key_callout");
var _agent_status_instructions = require("../agent_status_instructions");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const createPhpAgentInstructions = commonOptions => {
  const {
    baseUrl,
    apmServerUrl,
    apiKeyDetails,
    checkAgentStatus,
    agentStatus,
    agentStatusLoading
  } = commonOptions;
  return [{
    title: _i18n.i18n.translate('xpack.apm.onboarding.php.download.title', {
      defaultMessage: 'Download the APM agent'
    }),
    children: /*#__PURE__*/_react.default.createElement(_eui.EuiMarkdownFormat, null, _i18n.i18n.translate('xpack.apm.onboarding.php.download.textPre', {
      defaultMessage: 'Download the package corresponding to your platform from [GitHub releases]({githubReleasesLink}).',
      values: {
        githubReleasesLink: 'https://github.com/elastic/apm-agent-php/releases'
      }
    }))
  }, {
    title: _i18n.i18n.translate('xpack.apm.onboarding.php.installPackage.title', {
      defaultMessage: 'Install the downloaded package'
    }),
    children: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiMarkdownFormat, null, _i18n.i18n.translate('xpack.apm.onboarding.php.installPackage.textPre', {
      defaultMessage: 'For example on Alpine Linux using APK package:'
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
      language: "bash",
      isCopyable: true
    }, "apk add --allow-untrusted <package-file>.apk"), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiMarkdownFormat, null, _i18n.i18n.translate('xpack.apm.onboarding.php.installPackage.textPost', {
      defaultMessage: 'See the [documentation]({documentationLink}) for installation commands on other supported platforms and advanced installation.',
      values: {
        documentationLink: `${baseUrl}guide/en/apm/agent/php/current/setup.html`
      }
    })))
  }, {
    title: _i18n.i18n.translate('xpack.apm.onboarding.php.configureAgent.title', {
      defaultMessage: 'Configure the agent'
    }),
    children: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiMarkdownFormat, null, _i18n.i18n.translate('xpack.apm.onboarding.php.Configure the agent.textPre', {
      defaultMessage: 'APM is automatically started when your app boots. Configure the agent either via `php.ini` file:'
    })), ((apiKeyDetails === null || apiKeyDetails === void 0 ? void 0 : apiKeyDetails.displayApiKeySuccessCallout) || (apiKeyDetails === null || apiKeyDetails === void 0 ? void 0 : apiKeyDetails.displayApiKeyErrorCallout)) && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_api_key_callout.ApiKeyCallout, {
      isError: apiKeyDetails === null || apiKeyDetails === void 0 ? void 0 : apiKeyDetails.displayApiKeyErrorCallout,
      isSuccess: apiKeyDetails === null || apiKeyDetails === void 0 ? void 0 : apiKeyDetails.displayApiKeySuccessCallout,
      errorMessage: apiKeyDetails === null || apiKeyDetails === void 0 ? void 0 : apiKeyDetails.errorMessage
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null)), /*#__PURE__*/_react.default.createElement(_agent_config_instructions.AgentConfigInstructions, {
      variantId: _instruction_variants.INSTRUCTION_VARIANT.PHP,
      apmServerUrl: apmServerUrl,
      apiKey: apiKeyDetails === null || apiKeyDetails === void 0 ? void 0 : apiKeyDetails.apiKey,
      createApiKey: apiKeyDetails === null || apiKeyDetails === void 0 ? void 0 : apiKeyDetails.createAgentKey,
      createApiKeyLoading: apiKeyDetails === null || apiKeyDetails === void 0 ? void 0 : apiKeyDetails.createApiKeyLoading
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiMarkdownFormat, null, _i18n.i18n.translate('xpack.apm.onboarding.php.configureAgent.textPost', {
      defaultMessage: 'See the [documentation]({documentationLink}) for configuration options and advanced usage.\n\n',
      values: {
        documentationLink: `${baseUrl}guide/en/apm/agent/php/current/configuration.html`
      }
    })))
  }, (0, _agent_status_instructions.agentStatusCheckInstruction)({
    checkAgentStatus,
    agentStatus,
    agentStatusLoading
  })];
};
exports.createPhpAgentInstructions = createPhpAgentInstructions;