"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.JsonMetricsDashboard = JsonMetricsDashboard;
exports.getFilters = getFilters;
var _react = _interopRequireWildcard(require("react"));
var _public = require("@kbn/embeddable-plugin/public");
var _public2 = require("@kbn/dashboard-plugin/public");
var _esQuery = require("@kbn/es-query");
var _i18n = require("@kbn/i18n");
var _public3 = require("@kbn/controls-plugin/public");
var _environment_filter_values = require("../../../../../common/environment_filter_values");
var _use_apm_plugin_context = require("../../../../context/apm_plugin/use_apm_plugin_context");
var _use_apm_service_context = require("../../../../context/apm_service/use_apm_service_context");
var _use_apm_params = require("../../../../hooks/use_apm_params");
var _helper = require("./helper");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function JsonMetricsDashboard(dashboardProps) {
  const [dashboard, setDashboard] = (0, _react.useState)(undefined);
  const {
    dataView
  } = dashboardProps;
  const {
    query: {
      environment,
      kuery,
      rangeFrom,
      rangeTo
    }
  } = (0, _use_apm_params.useApmParams)('/services/{serviceName}/metrics');
  const {
    core: {
      notifications
    }
  } = (0, _use_apm_plugin_context.useApmPluginContext)();
  const {
    serviceName
  } = (0, _use_apm_service_context.useApmServiceContext)();
  (0, _react.useEffect)(() => {
    if (!dashboard) return;
    dashboard.setTimeRange({
      from: rangeFrom,
      to: rangeTo
    });
    dashboard.setQuery({
      query: kuery,
      language: 'kuery'
    });
  }, [kuery, dashboard, rangeFrom, rangeTo]);
  (0, _react.useEffect)(() => {
    if (!dashboard) return;
    dashboard.setFilters(dataView ? getFilters(serviceName, environment, dataView) : []);
  }, [dataView, serviceName, environment, dashboard]);
  return /*#__PURE__*/_react.default.createElement(_public2.DashboardRenderer, {
    getCreationOptions: () => getCreationOptions(dashboardProps, notifications, dataView),
    onApiAvailable: setDashboard
  });
}
async function getCreationOptions(dashboardProps, notifications, dataView) {
  try {
    var _dataView$id;
    const controlGroupState = {};
    await _public3.controlGroupStateBuilder.addDataControlFromField(controlGroupState, {
      dataViewId: (_dataView$id = dataView.id) !== null && _dataView$id !== void 0 ? _dataView$id : '',
      title: 'Node name',
      fieldName: 'service.node.name',
      width: 'medium',
      grow: true
    });
    const panels = await (0, _helper.convertSavedDashboardToPanels)(dashboardProps, dataView);
    if (!panels) {
      throw new Error('Failed parsing dashboard panels.');
    }
    return {
      getInitialInput: () => ({
        viewMode: _public.ViewMode.VIEW,
        panels,
        controlGroupState
      })
    };
  } catch (error) {
    notifications.toasts.addDanger(getLoadFailureToastLabels(dashboardProps, error));
    return {};
  }
}
function getFilters(serviceName, environment, dataView) {
  const filters = [];
  const serviceNameField = dataView.getFieldByName('service.name');
  if (serviceNameField) {
    const serviceNameFilter = (0, _esQuery.buildPhraseFilter)(serviceNameField, serviceName, dataView);
    filters.push(serviceNameFilter);
  }
  const environmentField = dataView.getFieldByName('service.environment');
  if (environmentField && environment && environment !== _environment_filter_values.ENVIRONMENT_ALL.value) {
    if (environment === _environment_filter_values.ENVIRONMENT_NOT_DEFINED.value) {
      const envExistsFilter = (0, _esQuery.buildExistsFilter)(environmentField, dataView);
      envExistsFilter.meta.negate = true;
      filters.push(envExistsFilter);
    } else {
      const environmentFilter = (0, _esQuery.buildPhraseFilter)(environmentField, environment, dataView);
      filters.push(environmentFilter);
    }
  }
  return filters;
}
function getLoadFailureToastLabels(props, error) {
  var _props$agentName, _props$runtimeName;
  return {
    title: _i18n.i18n.translate('xpack.apm.runtimeMetricsJsonDashboards.loadFailure.toast.title', {
      defaultMessage: 'Error while loading dashboard for agent "{agentName}" on runtime "{runtimeName}".',
      values: {
        agentName: (_props$agentName = props.agentName) !== null && _props$agentName !== void 0 ? _props$agentName : 'unknown',
        runtimeName: (_props$runtimeName = props.runtimeName) !== null && _props$runtimeName !== void 0 ? _props$runtimeName : 'unknown'
      }
    }),
    text: error.message
  };
}