"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.convertSavedDashboardToPanels = convertSavedDashboardToPanels;
exports.hasDashboardFile = hasDashboardFile;
var _dashboard_catalog = require("./dashboards/dashboard_catalog");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function hasDashboardFile(props) {
  return !!getDashboardFileName(props);
}
function getDashboardFileName({
  agentName
}) {
  const dashboardFile = agentName && _dashboard_catalog.AGENT_NAME_DASHBOARD_FILE_MAPPING[agentName];
  return dashboardFile;
}
const getAdhocDataView = dataView => {
  return {
    [dataView.id]: {
      ...dataView
    }
  };
};
async function convertSavedDashboardToPanels(props, dataView) {
  const dashboardFilename = getDashboardFileName(props);
  const dashboardJSON = !!dashboardFilename ? await (0, _dashboard_catalog.loadDashboardFile)(dashboardFilename) : undefined;
  if (!dashboardFilename || !dashboardJSON) {
    return undefined;
  }
  const panelsRawObjects = JSON.parse(dashboardJSON.attributes.panelsJSON);
  const panels = panelsRawObjects.reduce((acc, panel) => {
    const {
      gridData,
      embeddableConfig,
      panelIndex,
      title
    } = panel;
    const {
      attributes
    } = embeddableConfig;
    const {
      state
    } = attributes;
    const {
      datasourceStates: {
        formBased: {
          layers
        }
      }
    } = state;
    acc[gridData.i] = {
      type: panel.type,
      gridData,
      explicitInput: {
        id: panelIndex,
        ...embeddableConfig,
        title,
        attributes: {
          ...attributes,
          references: [],
          state: {
            ...state,
            adHocDataViews: getAdhocDataView(dataView),
            internalReferences: Object.keys(layers).map(layerId => ({
              id: dataView.id,
              name: `indexpattern-datasource-layer-${layerId}`,
              type: 'index-pattern'
            }))
          }
        }
      }
    };
    return acc;
  }, {});
  return panels;
}