"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ExceptionStacktraceTitle = ExceptionStacktraceTitle;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function ExceptionStacktraceTitle({
  message,
  type,
  codeLanguage
}) {
  let title = message;
  switch (codeLanguage === null || codeLanguage === void 0 ? void 0 : codeLanguage.toLowerCase()) {
    case 'c#':
    case 'javascript':
    case 'php':
      title = `${type}: ${message}`;
      break;
    case 'java':
      title = message ? `${type}: ${message}` : type;
      break;
    case 'ruby':
      title = `${type} (${message ? message : type})`;
      break;
    case 'go':
    case 'python':
    default:
      break;
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement("h4", null, title));
}