"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DiagnosticsIndexTemplates = DiagnosticsIndexTemplates;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _use_fetcher = require("../../../hooks/use_fetcher");
var _use_diagnostics = require("./context/use_diagnostics");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function DiagnosticsIndexTemplates() {
  var _diagnosticsBundle$ap;
  const {
    diagnosticsBundle,
    status
  } = (0, _use_diagnostics.useDiagnosticsContext)();
  if (status === _use_fetcher.FETCH_STATUS.LOADING) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingElastic, {
      size: "m"
    });
  }
  const items = (_diagnosticsBundle$ap = diagnosticsBundle === null || diagnosticsBundle === void 0 ? void 0 : diagnosticsBundle.apmIndexTemplates) !== null && _diagnosticsBundle$ap !== void 0 ? _diagnosticsBundle$ap : [];
  const columns = [{
    name: 'Index template name',
    field: 'name',
    render: (_, {
      name
    }) => name,
    truncateText: true
  }, {
    name: 'Status',
    field: 'status',
    render: (_, {
      exists,
      isNonStandard
    }) => {
      if (isNonStandard) {
        return /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
          color: "warning"
        }, "Non standard");
      }
      if (!exists) {
        return /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
          color: "danger"
        }, "Not found");
      }
      return /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
        color: "green"
      }, "OK");
    },
    truncateText: true
  }];
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(NonStandardIndexTemplateCalout, {
    diagnosticsBundle: diagnosticsBundle
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, "This section lists the names of the default APM Index Templates and whether it exists or not"), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiBasicTable, {
    tableCaption: "Expected Index Templates",
    items: items,
    rowHeader: "firstName",
    columns: columns
  }));
}
function NonStandardIndexTemplateCalout({
  diagnosticsBundle
}) {
  var _diagnosticsBundle$ap2;
  const nonStandardIndexTemplates = diagnosticsBundle === null || diagnosticsBundle === void 0 ? void 0 : (_diagnosticsBundle$ap2 = diagnosticsBundle.apmIndexTemplates) === null || _diagnosticsBundle$ap2 === void 0 ? void 0 : _diagnosticsBundle$ap2.filter(({
    isNonStandard
  }) => isNonStandard);
  if (!(nonStandardIndexTemplates !== null && nonStandardIndexTemplates !== void 0 && nonStandardIndexTemplates.length)) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: "Non-standard index templates",
    color: "warning",
    iconType: "warning"
  }, "The following index templates do not follow the recommended naming scheme:", ' ', nonStandardIndexTemplates.map(({
    name
  }) => /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, null, name))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null));
}