"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DependenciesInventoryTable = DependenciesInventoryTable;
var _analytics = require("@kbn/analytics");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _react2 = require("@emotion/react");
var _public = require("@kbn/observability-shared-plugin/public");
var _get_comparison_options = require("../../../shared/time_comparison/get_comparison_options");
var _connections = require("../../../../../common/connections");
var _use_apm_params = require("../../../../hooks/use_apm_params");
var _use_fetcher = require("../../../../hooks/use_fetcher");
var _use_time_range = require("../../../../hooks/use_time_range");
var _dependency_link = require("../../../shared/links/dependency_link");
var _dependencies_table = require("../../../shared/dependencies_table");
var _random_sampler_badge = require("../random_sampler_badge");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function DependenciesInventoryTable() {
  var _data$dependencies$ma;
  const {
    query: {
      rangeFrom,
      rangeTo,
      environment,
      kuery,
      comparisonEnabled,
      offset
    }
  } = (0, _use_apm_params.useApmParams)('/dependencies/inventory');
  const {
    start,
    end
  } = (0, _use_time_range.useTimeRange)({
    rangeFrom,
    rangeTo
  });
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const trackEvent = (0, _public.useUiTracker)();
  const {
    data,
    status
  } = (0, _use_fetcher.useFetcher)(callApmApi => {
    if (!start || !end) {
      return;
    }
    return callApmApi('GET /internal/apm/dependencies/top_dependencies', {
      params: {
        query: {
          start,
          end,
          environment,
          numBuckets: 8,
          offset: comparisonEnabled && (0, _get_comparison_options.isTimeComparison)(offset) ? offset : undefined,
          kuery
        }
      }
    });
  }, [start, end, environment, offset, kuery, comparisonEnabled]);
  const dependencies = (_data$dependencies$ma = data === null || data === void 0 ? void 0 : data.dependencies.map(dependency => {
    const {
      location
    } = dependency;
    const name = (0, _connections.getNodeName)(location);
    if (location.type !== _connections.NodeType.dependency) {
      throw new Error('Expected a dependency node');
    }
    const link = /*#__PURE__*/_react.default.createElement(_dependency_link.DependencyLink, {
      type: location.spanType,
      subtype: location.spanSubtype,
      query: {
        dependencyName: location.dependencyName,
        comparisonEnabled,
        offset,
        environment,
        kuery,
        rangeFrom,
        rangeTo
      },
      onClick: () => {
        trackEvent({
          app: 'apm',
          metricType: _analytics.METRIC_TYPE.CLICK,
          metric: 'dependencies_inventory_to_dependency_detail'
        });
      }
    });
    return {
      name,
      currentStats: dependency.currentStats,
      previousStats: dependency.previousStats,
      link
    };
  })) !== null && _data$dependencies$ma !== void 0 ? _data$dependencies$ma : [];
  const showRandomSamplerBadge = (data === null || data === void 0 ? void 0 : data.sampled) && status === _use_fetcher.FETCH_STATUS.SUCCESS;
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("div", {
    css: (0, _react2.css)`
          min-height: ${euiTheme.size.l};
        `
  }, showRandomSamplerBadge && /*#__PURE__*/_react.default.createElement(_random_sampler_badge.RandomSamplerBadge, null)), /*#__PURE__*/_react.default.createElement(_dependencies_table.DependenciesTable, {
    dependencies: dependencies,
    title: null,
    nameColumnTitle: _i18n.i18n.translate('xpack.apm.dependenciesInventory.dependencyTableColumn', {
      defaultMessage: 'Dependency'
    }),
    status: status,
    compact: false,
    initialPageSize: 25
  }));
}