"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FailedTransactionsCorrelations = FailedTransactionsCorrelations;
var _react = _interopRequireWildcard(require("react"));
var _reactRouterDom = require("react-router-dom");
var _lodash = require("lodash");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/observability-shared-plugin/public");
var _common = require("@kbn/observability-plugin/common");
var _field_stats_popover = require("./context_popover/field_stats_popover");
var _formatters = require("../../../../common/utils/formatters");
var _use_apm_plugin_context = require("../../../context/apm_plugin/use_apm_plugin_context");
var _use_local_storage = require("../../../hooks/use_local_storage");
var _use_fetcher = require("../../../hooks/use_fetcher");
var _use_theme = require("../../../hooks/use_theme");
var _url_helpers = require("../../shared/links/url_helpers");
var _correlations_table = require("./correlations_table");
var _failed_transactions_correlations_help_popover = require("./failed_transactions_correlations_help_popover");
var _get_failed_transactions_correlation_impact_label = require("./utils/get_failed_transactions_correlation_impact_label");
var _get_overall_histogram = require("./utils/get_overall_histogram");
var _duration_distribution_chart = require("../../shared/charts/duration_distribution_chart");
var _empty_state_prompt = require("./empty_state_prompt");
var _cross_cluster_search_warning = require("./cross_cluster_search_warning");
var _progress_controls = require("./progress_controls");
var _use_failed_transactions_correlations = require("./use_failed_transactions_correlations");
var _get_transaction_distribution_chart_data = require("./get_transaction_distribution_chart_data");
var _chart_title_tool_tip = require("./chart_title_tool_tip");
var _duration_distribution_chart_with_scrubber = require("../../shared/charts/duration_distribution_chart_with_scrubber");
var _total_doc_count_label = require("../../shared/charts/duration_distribution_chart/total_doc_count_label");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function FailedTransactionsCorrelations({
  onFilter
}) {
  var _response$percentileT;
  const euiTheme = (0, _use_theme.useTheme)();
  const {
    core: {
      notifications
    }
  } = (0, _use_apm_plugin_context.useApmPluginContext)();
  const trackApmEvent = (0, _public.useUiTracker)({
    app: 'apm'
  });
  const {
    progress,
    response,
    startFetch,
    cancelFetch
  } = (0, _use_failed_transactions_correlations.useFailedTransactionsCorrelations)();
  const {
    overallHistogram,
    hasData,
    status
  } = (0, _get_overall_histogram.getOverallHistogram)(response, progress.isRunning);
  const history = (0, _reactRouterDom.useHistory)();
  const [showStats, setShowStats] = (0, _use_local_storage.useLocalStorage)('apmFailedTransactionsShowAdvancedStats', false);
  const toggleShowStats = (0, _react.useCallback)(() => {
    setShowStats(!showStats);
  }, [setShowStats, showStats]);
  const onAddFilter = (0, _react.useCallback)(({
    fieldName,
    fieldValue,
    include
  }) => {
    if (include) {
      (0, _url_helpers.push)(history, {
        query: {
          kuery: `${fieldName}:"${fieldValue}"`
        }
      });
      trackApmEvent({
        metric: 'correlations_term_include_filter'
      });
    } else {
      (0, _url_helpers.push)(history, {
        query: {
          kuery: `not ${fieldName}:"${fieldValue}"`
        }
      });
      trackApmEvent({
        metric: 'correlations_term_exclude_filter'
      });
    }
    onFilter();
  }, [onFilter, history, trackApmEvent]);
  const failedTransactionsCorrelationsColumns = (0, _react.useMemo)(() => {
    const percentageColumns = showStats ? [{
      width: '100px',
      field: 'pValue',
      name: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, _i18n.i18n.translate('xpack.apm.correlations.failedTransactions.correlationsTable.pValueLabel', {
        defaultMessage: 'p-value'
      }), "\xA0", /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
        size: "s",
        color: "subdued",
        type: "questionInCircle",
        className: "eui-alignTop",
        content: _i18n.i18n.translate('xpack.apm.correlations.failedTransactions.correlationsTable.pValueDescription', {
          defaultMessage: 'The chance of getting at least this amount of field name and value for failed transactions given its prevalence in successful transactions.'
        })
      })),
      render: pValue => pValue.toPrecision(3),
      sortable: true
    }, {
      width: '100px',
      field: 'failurePercentage',
      name: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, _i18n.i18n.translate('xpack.apm.correlations.failedTransactions.correlationsTable.failurePercentageLabel', {
        defaultMessage: 'Failure %'
      }), "\xA0", /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
        size: "s",
        color: "subdued",
        type: "questionInCircle",
        className: "eui-alignTop",
        content: _i18n.i18n.translate('xpack.apm.correlations.failedTransactions.correlationsTable.failurePercentageDescription', {
          defaultMessage: 'Percentage of time the term appear in failed transactions.'
        })
      })),
      render: (_, {
        failurePercentage
      }) => (0, _formatters.asPercent)(failurePercentage, 1),
      sortable: true
    }, {
      field: 'successPercentage',
      width: '100px',
      name: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, _i18n.i18n.translate('xpack.apm.correlations.failedTransactions.correlationsTable.successPercentageLabel', {
        defaultMessage: 'Success %'
      }), "\xA0", /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
        size: "s",
        color: "subdued",
        type: "questionInCircle",
        className: "eui-alignTop",
        content: _i18n.i18n.translate('xpack.apm.correlations.failedTransactions.correlationsTable.successPercentageDescription', {
          defaultMessage: 'Percentage of time the term appear in successful transactions.'
        })
      })),
      render: (_, {
        successPercentage
      }) => (0, _formatters.asPercent)(successPercentage, 1),
      sortable: true
    }] : [];
    return [{
      width: '116px',
      field: 'normalizedScore',
      name: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, _i18n.i18n.translate('xpack.apm.correlations.failedTransactions.correlationsTable.scoreLabel', {
        defaultMessage: 'Score'
      }), "\xA0", /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
        size: "s",
        color: "subdued",
        type: "questionInCircle",
        className: "eui-alignTop",
        content: _i18n.i18n.translate('xpack.apm.correlations.failedTransactions.correlationsTable.scoreTooltip', {
          defaultMessage: 'The score [0-1] of an attribute; the greater the score, the more an attribute contributes to failed transactions.'
        })
      })),
      render: (_, {
        normalizedScore
      }) => {
        return /*#__PURE__*/_react.default.createElement("div", null, (0, _formatters.asPreciseDecimal)(normalizedScore, 2));
      },
      sortable: true
    }, {
      width: '116px',
      field: 'pValue',
      name: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, _i18n.i18n.translate('xpack.apm.correlations.failedTransactions.correlationsTable.impactLabel', {
        defaultMessage: 'Impact'
      })),
      render: (_, {
        pValue,
        isFallbackResult
      }) => {
        const label = (0, _get_failed_transactions_correlation_impact_label.getFailedTransactionsCorrelationImpactLabel)(pValue, isFallbackResult);
        return label ? /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
          color: label.color
        }, label.impact) : null;
      },
      sortable: true
    }, {
      field: 'fieldName',
      name: _i18n.i18n.translate('xpack.apm.correlations.failedTransactions.correlationsTable.fieldNameLabel', {
        defaultMessage: 'Field name'
      }),
      render: (_, {
        fieldName,
        fieldValue
      }) => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, fieldName, /*#__PURE__*/_react.default.createElement(_field_stats_popover.FieldStatsPopover, {
        fieldName: fieldName,
        fieldValue: fieldValue,
        onAddFilter: onAddFilter
      })),
      sortable: true
    }, {
      field: 'fieldValue',
      name: _i18n.i18n.translate('xpack.apm.correlations.failedTransactions.correlationsTable.fieldValueLabel', {
        defaultMessage: 'Field value'
      }),
      render: (_, {
        fieldValue
      }) => String(fieldValue).slice(0, 50),
      sortable: true
    }, ...percentageColumns, {
      width: '100px',
      actions: [{
        name: _i18n.i18n.translate('xpack.apm.correlations.correlationsTable.filterLabel', {
          defaultMessage: 'Filter'
        }),
        description: _i18n.i18n.translate('xpack.apm.correlations.correlationsTable.filterDescription', {
          defaultMessage: 'Filter by value'
        }),
        icon: 'plusInCircle',
        type: 'icon',
        onClick: ({
          fieldName,
          fieldValue
        }) => onAddFilter({
          fieldName,
          fieldValue,
          include: true
        })
      }, {
        name: _i18n.i18n.translate('xpack.apm.correlations.correlationsTable.excludeLabel', {
          defaultMessage: 'Exclude'
        }),
        description: _i18n.i18n.translate('xpack.apm.correlations.correlationsTable.excludeDescription', {
          defaultMessage: 'Filter out value'
        }),
        icon: 'minusInCircle',
        type: 'icon',
        onClick: ({
          fieldName,
          fieldValue
        }) => onAddFilter({
          fieldName,
          fieldValue,
          include: false
        })
      }]
    }];
  }, [onAddFilter, showStats]);
  (0, _react.useEffect)(() => {
    if (progress.error) {
      notifications.toasts.addDanger({
        title: _i18n.i18n.translate('xpack.apm.correlations.failedTransactions.errorTitle', {
          defaultMessage: 'An error occurred performing correlations on failed transactions'
        }),
        text: progress.error
      });
    }
  }, [progress.error, notifications.toasts]);
  const [sortField, setSortField] = (0, _react.useState)('normalizedScore');
  const [sortDirection, setSortDirection] = (0, _react.useState)('desc');
  const onTableChange = (0, _react.useCallback)(({
    sort
  }) => {
    const {
      field: currentSortField,
      direction: currentSortDirection
    } = sort;
    setSortField(currentSortField);
    setSortDirection(currentSortDirection);
  }, []);
  const sorting = {
    sort: {
      field: sortField,
      direction: sortDirection
    }
  };
  const correlationTerms = (0, _react.useMemo)(() => {
    var _response$failedTrans;
    if (progress.loaded === 1 && (response === null || response === void 0 ? void 0 : (_response$failedTrans = response.failedTransactionsCorrelations) === null || _response$failedTrans === void 0 ? void 0 : _response$failedTrans.length) === 0 && response.fallbackResult !== undefined) {
      return [{
        ...response.fallbackResult,
        isFallbackResult: true
      }];
    }
    return (0, _lodash.orderBy)(response.failedTransactionsCorrelations,
    // The smaller the p value the higher the impact
    // So we want to sort by the normalized score here
    // which goes from 0 -> 1
    sortField === 'pValue' ? 'normalizedScore' : sortField, sortDirection);
  }, [response.failedTransactionsCorrelations, response.fallbackResult, progress.loaded, sortField, sortDirection]);
  const [pinnedSignificantTerm, setPinnedSignificantTerm] = (0, _react.useState)(null);
  const [selectedSignificantTerm, setSelectedSignificantTerm] = (0, _react.useState)(null);
  const selectedTerm = (0, _react.useMemo)(() => {
    if (!correlationTerms) {
      return;
    } else if (selectedSignificantTerm) {
      return correlationTerms === null || correlationTerms === void 0 ? void 0 : correlationTerms.find(h => h.fieldName === selectedSignificantTerm.fieldName && h.fieldValue === selectedSignificantTerm.fieldValue);
    } else if (pinnedSignificantTerm) {
      return correlationTerms.find(h => h.fieldName === pinnedSignificantTerm.fieldName && h.fieldValue === pinnedSignificantTerm.fieldValue);
    }
    return correlationTerms[0];
  }, [correlationTerms, pinnedSignificantTerm, selectedSignificantTerm]);
  const showCorrelationsTable = progress.isRunning || correlationTerms.length > 0;
  const showCorrelationsEmptyStatePrompt = correlationTerms.length < 1 && (progress.loaded === 1 || !progress.isRunning);
  const transactionDistributionChartData = (0, _get_transaction_distribution_chart_data.getTransactionDistributionChartData)({
    euiTheme,
    allTransactionsHistogram: overallHistogram,
    failedTransactionsHistogram: response.errorHistogram,
    selectedTerm
  });
  return /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": "apmFailedTransactionsCorrelationsTabContent"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    style: {
      minHeight: _duration_distribution_chart_with_scrubber.MIN_TAB_TITLE_HEIGHT
    },
    alignItems: "center",
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs",
    "data-test-subj": "apmFailedTransactionsCorrelationsTabTitle"
  }, /*#__PURE__*/_react.default.createElement("h5", {
    "data-test-subj": "apmFailedTransactionsCorrelationsChartTitle"
  }, _i18n.i18n.translate('xpack.apm.correlations.failedTransactions.panelTitle', {
    defaultMessage: 'Failed transactions latency distribution'
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_chart_title_tool_tip.ChartTitleToolTip, null)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_total_doc_count_label.TotalDocCountLabel, {
    eventType: _common.ProcessorEvent.transaction,
    totalDocCount: response.totalDocCount
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_failed_transactions_correlations_help_popover.FailedTransactionsCorrelationsHelpPopover, null))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_duration_distribution_chart.DurationDistributionChart, {
    markerValue: (_response$percentileT = response.percentileThresholdValue) !== null && _response$percentileT !== void 0 ? _response$percentileT : 0,
    data: transactionDistributionChartData,
    hasData: hasData,
    status: status,
    eventType: _common.ProcessorEvent.transaction
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement("span", {
    "data-test-subj": "apmFailedTransactionsCorrelationsTablePanelTitle"
  }, _i18n.i18n.translate('xpack.apm.correlations.failedTransactions.tableTitle', {
    defaultMessage: 'Correlations'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    style: {
      display: 'flex',
      flexDirection: 'row',
      paddingLeft: euiTheme.eui.euiSizeS
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    label: _i18n.i18n.translate('xpack.apm.correlations.latencyCorrelations.advancedStatisticsLabel', {
      defaultMessage: 'Advanced statistics'
    }),
    checked: showStats,
    onChange: toggleShowStats,
    compressed: true
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
    size: "m",
    iconProps: {
      style: {
        marginLeft: euiTheme.eui.euiSizeXS
      }
    },
    content: _i18n.i18n.translate('xpack.apm.correlations.latencyCorrelations.advancedStatisticsTooltipContent', {
      defaultMessage: 'Enable additional statistical information for the correlation results.'
    }),
    type: "questionInCircle"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_progress_controls.CorrelationsProgressControls, {
    progress: progress.loaded,
    isRunning: progress.isRunning,
    onRefresh: startFetch,
    onCancel: cancelFetch
  }), response.ccsWarning && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_cross_cluster_search_warning.CrossClusterSearchCompatibilityWarning, {
    version: "7.15"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": "apmCorrelationsTable"
  }, showCorrelationsTable && /*#__PURE__*/_react.default.createElement(_correlations_table.CorrelationsTable, {
    columns: failedTransactionsCorrelationsColumns,
    rowHeader: "normalizedScore",
    significantTerms: correlationTerms,
    status: progress.isRunning ? _use_fetcher.FETCH_STATUS.LOADING : _use_fetcher.FETCH_STATUS.SUCCESS,
    setPinnedSignificantTerm: setPinnedSignificantTerm,
    setSelectedSignificantTerm: setSelectedSignificantTerm,
    selectedTerm: selectedTerm,
    onTableChange: onTableChange,
    sorting: sorting
  }), showCorrelationsEmptyStatePrompt && /*#__PURE__*/_react.default.createElement(_empty_state_prompt.CorrelationsEmptyStatePrompt, null)));
}