"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.injectActionParams = injectActionParams;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function injectActionParams({
  actionTypeId,
  actionParams,
  ruleName,
  ruleUrl = {}
}) {
  // Inject kibanaFooterLink if action type is email. This is used by the email action type
  // to inject a "View alert in Kibana" with a URL in the email's footer.
  if (actionTypeId === '.email') {
    var _ruleUrl$spaceIdSegme, _ruleUrl$relativePath;
    // path should not include basePathname since it is part of kibanaBaseUrl already
    const path = [(_ruleUrl$spaceIdSegme = ruleUrl.spaceIdSegment) !== null && _ruleUrl$spaceIdSegme !== void 0 ? _ruleUrl$spaceIdSegme : '', (_ruleUrl$relativePath = ruleUrl.relativePath) !== null && _ruleUrl$relativePath !== void 0 ? _ruleUrl$relativePath : ''].join('');
    return {
      ...actionParams,
      kibanaFooterLink: {
        path,
        text: _i18n.i18n.translate('xpack.alerting.injectActionParams.email.kibanaFooterLinkText', {
          defaultMessage: 'View rule in Kibana'
        })
      }
    };
  }
  if (actionTypeId === '.pagerduty') {
    var _ruleUrl$absoluteUrl;
    /**
     * TODO: Remove and use connector adapters
     */
    const path = (_ruleUrl$absoluteUrl = ruleUrl === null || ruleUrl === void 0 ? void 0 : ruleUrl.absoluteUrl) !== null && _ruleUrl$absoluteUrl !== void 0 ? _ruleUrl$absoluteUrl : '';
    if (path.length === 0) {
      return actionParams;
    }
    const links = Array.isArray(actionParams.links) ? actionParams.links : [];
    return {
      ...actionParams,
      links: [{
        href: path,
        text: _i18n.i18n.translate('xpack.alerting.injectActionParams.pagerduty.kibanaLinkText', {
          defaultMessage: 'Elastic Rule "{ruleName}"',
          values: {
            ruleName: ruleName !== null && ruleName !== void 0 ? ruleName : 'Unknown'
          }
        })
      }, ...links]
    };
  }

  // Fallback, return action params unchanged
  return actionParams;
}