"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getRuleType = exports.getRule = exports.getDefaultSchedulerContext = exports.generateRecoveredAlert = exports.generateAlert = void 0;
var _configSchema = require("@kbn/config-schema");
var _connector_adapter_registry = require("../../connector_adapters/connector_adapter_registry");
var _alert = require("../../alert");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const apiKey = Buffer.from('123:abc').toString('base64');
const generateAlert = ({
  id,
  group = 'default',
  context,
  state,
  scheduleActions = true,
  throttledActions = {},
  lastScheduledActionsGroup = 'default',
  maintenanceWindowIds,
  pendingRecoveredCount,
  activeCount
}) => {
  const alert = new _alert.Alert(String(id), {
    state: state || {
      test: true
    },
    meta: {
      maintenanceWindowIds,
      lastScheduledActions: {
        date: new Date().toISOString(),
        group: lastScheduledActionsGroup,
        actions: throttledActions
      },
      pendingRecoveredCount,
      activeCount
    }
  });
  if (scheduleActions) {
    alert.scheduleActions(group);
  }
  if (context) {
    alert.setContext(context);
  }
  return {
    [id]: alert
  };
};
exports.generateAlert = generateAlert;
const generateRecoveredAlert = ({
  id,
  state
}) => {
  const alert = new _alert.Alert(String(id), {
    state: state || {
      test: true
    },
    meta: {
      lastScheduledActions: {
        date: new Date().toISOString(),
        group: 'recovered',
        actions: {}
      }
    }
  });
  return {
    [id]: alert
  };
};
exports.generateRecoveredAlert = generateRecoveredAlert;
const getRule = (overrides = {}) => ({
  id: '1',
  name: 'name-of-alert',
  tags: ['tag-A', 'tag-B'],
  mutedInstanceIds: [],
  params: {
    foo: true,
    contextVal: 'My other {{context.value}} goes here',
    stateVal: 'My other {{state.value}} goes here'
  },
  schedule: {
    interval: '1m'
  },
  notifyWhen: 'onActiveAlert',
  actions: [{
    id: '1',
    group: 'default',
    actionTypeId: 'test',
    params: {
      foo: true,
      contextVal: 'My {{context.value}} goes here',
      stateVal: 'My {{state.value}} goes here',
      alertVal: 'My {{rule.id}} {{rule.name}} {{rule.spaceId}} {{rule.tags}} {{alert.id}} goes here'
    },
    uuid: '111-111'
  }],
  consumer: 'test-consumer',
  ...overrides
});
exports.getRule = getRule;
const getRuleType = () => ({
  id: 'test',
  name: 'Test',
  actionGroups: [{
    id: 'default',
    name: 'Default'
  }, {
    id: 'recovered',
    name: 'Recovered'
  }, {
    id: 'other-group',
    name: 'Other Group'
  }],
  defaultActionGroupId: 'default',
  minimumLicenseRequired: 'basic',
  isExportable: true,
  recoveryActionGroup: {
    id: 'recovered',
    name: 'Recovered'
  },
  executor: jest.fn(),
  category: 'test',
  producer: 'alerts',
  validate: {
    params: _configSchema.schema.any()
  },
  alerts: {
    context: 'context',
    mappings: {
      fieldMap: {
        field: {
          type: 'fieldType',
          required: false
        }
      }
    }
  },
  autoRecoverAlerts: false,
  validLegacyConsumers: []
});
exports.getRuleType = getRuleType;
const getDefaultSchedulerContext = (loggerMock, actionsPluginMock, alertingEventLoggerMock, actionsClientMock, alertsClientMock) => ({
  rule: getRule(),
  ruleType: getRuleType(),
  logger: loggerMock,
  taskRunnerContext: {
    actionsConfigMap: {
      default: {
        max: 1000
      }
    },
    actionsPlugin: actionsPluginMock,
    connectorAdapterRegistry: new _connector_adapter_registry.ConnectorAdapterRegistry()
  },
  apiKey,
  ruleConsumer: 'rule-consumer',
  executionId: '5f6aa57d-3e22-484e-bae8-cbed868f4d28',
  alertUuid: 'uuid-1',
  ruleLabel: 'rule-label',
  request: {},
  alertingEventLogger: alertingEventLoggerMock,
  previousStartedAt: null,
  taskInstance: {
    params: {
      spaceId: 'test1',
      alertId: '1'
    }
  },
  actionsClient: actionsClientMock,
  alertsClient: alertsClientMock
});
exports.getDefaultSchedulerContext = getDefaultSchedulerContext;