"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.rawAdHocRunParamsSchema = void 0;
var _configSchema = require("@kbn/config-schema");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const rawAdHocRunStatus = _configSchema.schema.oneOf([_configSchema.schema.literal('complete'), _configSchema.schema.literal('pending'), _configSchema.schema.literal('running'), _configSchema.schema.literal('error'), _configSchema.schema.literal('timeout')]);
const rawAdHocRunSchedule = _configSchema.schema.object({
  interval: _configSchema.schema.string(),
  status: rawAdHocRunStatus,
  runAt: _configSchema.schema.string()
});
const rawAdHocRunParamsRuleSchema = _configSchema.schema.object({
  name: _configSchema.schema.string(),
  tags: _configSchema.schema.arrayOf(_configSchema.schema.string()),
  alertTypeId: _configSchema.schema.string(),
  params: _configSchema.schema.recordOf(_configSchema.schema.string(), _configSchema.schema.maybe(_configSchema.schema.any())),
  apiKeyOwner: _configSchema.schema.nullable(_configSchema.schema.string()),
  apiKeyCreatedByUser: _configSchema.schema.maybe(_configSchema.schema.nullable(_configSchema.schema.boolean())),
  consumer: _configSchema.schema.string(),
  enabled: _configSchema.schema.boolean(),
  schedule: _configSchema.schema.object({
    interval: _configSchema.schema.string()
  }),
  createdBy: _configSchema.schema.nullable(_configSchema.schema.string()),
  updatedBy: _configSchema.schema.nullable(_configSchema.schema.string()),
  updatedAt: _configSchema.schema.string(),
  createdAt: _configSchema.schema.string(),
  revision: _configSchema.schema.number()
});
const rawAdHocRunParamsSchema = exports.rawAdHocRunParamsSchema = _configSchema.schema.object({
  apiKeyId: _configSchema.schema.string(),
  apiKeyToUse: _configSchema.schema.string(),
  createdAt: _configSchema.schema.string(),
  duration: _configSchema.schema.string(),
  enabled: _configSchema.schema.boolean(),
  end: _configSchema.schema.maybe(_configSchema.schema.string()),
  rule: rawAdHocRunParamsRuleSchema,
  spaceId: _configSchema.schema.string(),
  start: _configSchema.schema.string(),
  status: rawAdHocRunStatus,
  schedule: _configSchema.schema.arrayOf(rawAdHocRunSchedule)
});