"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getAlertFromRaw = getAlertFromRaw;
var _lodash = require("lodash");
var _lib = require("../../lib");
var _is_rule_snoozed = require("../../lib/is_rule_snoozed");
var _common = require("../common");
var _transform_raw_actions_to_domain_actions = require("../../application/rule/transforms/transform_raw_actions_to_domain_actions");
var _rules_client = require("../rules_client");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * @deprecated in favor of transformRuleAttributesToRuleDomain
 */
function getAlertFromRaw(opts) {
  const {
    excludeFromPublicApi = false,
    includeLegacyId = false,
    includeSnoozeData = false,
    omitGeneratedValues = true
  } = opts;
  const ruleType = opts.ruleTypeRegistry.get(opts.ruleTypeId);
  // In order to support the partial update API of Saved Objects we have to support
  // partial updates of an Alert, but when we receive an actual RawRule, it is safe
  // to cast the result to an Alert
  const res = getPartialRuleFromRaw({
    excludeFromPublicApi,
    id: opts.id,
    includeLegacyId,
    includeSnoozeData,
    isSystemAction: opts.isSystemAction,
    logger: opts.logger,
    omitGeneratedValues,
    rawRule: opts.rawRule,
    references: opts.references,
    ruleTypeId: opts.ruleTypeId,
    ruleType
  });
  // include to result because it is for internal rules client usage
  if (includeLegacyId) {
    return res;
  }
  // exclude from result because it is an internal variable
  return (0, _lodash.omit)(res, ['legacyId']);
}
function getPartialRuleFromRaw(opts) {
  var _partialRawRule$muteA, _getActiveScheduledSn, _partialRawRule$muteA2;
  const {
    excludeFromPublicApi = false,
    includeLegacyId = false,
    includeSnoozeData = false,
    omitGeneratedValues = true,
    rawRule
  } = opts;
  const {
    createdAt,
    updatedAt,
    meta,
    notifyWhen,
    legacyId,
    scheduledTaskId,
    params,
    executionStatus,
    monitoring,
    nextRun,
    schedule,
    actions,
    snoozeSchedule,
    lastRun,
    isSnoozedUntil: DoNotUseIsSnoozedUntil,
    ...partialRawRule
  } = rawRule;
  const snoozeScheduleDates = snoozeSchedule === null || snoozeSchedule === void 0 ? void 0 : snoozeSchedule.map(s => ({
    ...s,
    rRule: {
      ...s.rRule,
      dtstart: new Date(s.rRule.dtstart).toISOString(),
      ...(s.rRule.until ? {
        until: new Date(s.rRule.until).toISOString()
      } : {})
    }
  }));
  const includeSnoozeSchedule = snoozeSchedule !== undefined && !(0, _lodash.isEmpty)(snoozeSchedule) && !excludeFromPublicApi;
  const isSnoozedUntil = includeSnoozeSchedule ? (0, _lib.getRuleSnoozeEndTime)({
    muteAll: (_partialRawRule$muteA = partialRawRule.muteAll) !== null && _partialRawRule$muteA !== void 0 ? _partialRawRule$muteA : false,
    snoozeSchedule
  }) : null;
  const includeMonitoring = monitoring && !excludeFromPublicApi;
  const rule = {
    id: opts.id,
    notifyWhen,
    ...(0, _lodash.omit)(partialRawRule, excludeFromPublicApi ? [..._rules_client.fieldsToExcludeFromPublicApi] : ''),
    // we currently only support the Interval Schedule type
    // Once we support additional types, this type signature will likely change
    schedule: schedule,
    actions: actions ? (0, _transform_raw_actions_to_domain_actions.transformRawActionsToDomainActions)({
      ruleId: opts.id,
      actions,
      references: opts.references || [],
      isSystemAction: opts.isSystemAction,
      omitGeneratedValues
    }) : [],
    systemActions: actions ? (0, _transform_raw_actions_to_domain_actions.transformRawActionsToDomainSystemActions)({
      ruleId: opts.id,
      actions,
      references: opts.references || [],
      isSystemAction: opts.isSystemAction,
      omitGeneratedValues
    }) : [],
    params: (0, _common.injectReferencesIntoParams)(opts.id, opts.ruleType, params, opts.references || []),
    ...(excludeFromPublicApi ? {} : {
      snoozeSchedule: snoozeScheduleDates !== null && snoozeScheduleDates !== void 0 ? snoozeScheduleDates : []
    }),
    ...(includeSnoozeData && !excludeFromPublicApi ? {
      activeSnoozes: (_getActiveScheduledSn = (0, _is_rule_snoozed.getActiveScheduledSnoozes)({
        snoozeSchedule,
        muteAll: (_partialRawRule$muteA2 = partialRawRule.muteAll) !== null && _partialRawRule$muteA2 !== void 0 ? _partialRawRule$muteA2 : false
      })) === null || _getActiveScheduledSn === void 0 ? void 0 : _getActiveScheduledSn.map(s => s.id),
      isSnoozedUntil: isSnoozedUntil
    } : {}),
    ...(updatedAt ? {
      updatedAt: new Date(updatedAt)
    } : {}),
    ...(createdAt ? {
      createdAt: new Date(createdAt)
    } : {}),
    ...(scheduledTaskId ? {
      scheduledTaskId
    } : {}),
    ...(executionStatus ? {
      executionStatus: (0, _lib.ruleExecutionStatusFromRaw)(opts.logger, opts.id, executionStatus)
    } : {}),
    ...(includeMonitoring ? {
      monitoring: (0, _lib.convertMonitoringFromRawAndVerify)(opts.logger, opts.id, monitoring)
    } : {}),
    ...(nextRun ? {
      nextRun: new Date(nextRun)
    } : {}),
    ...(lastRun ? {
      lastRun: {
        ...lastRun,
        ...(lastRun.outcomeMsg && !Array.isArray(lastRun.outcomeMsg) ? {
          outcomeMsg: lastRun.outcomeMsg ? [lastRun.outcomeMsg] : null
        } : {
          outcomeMsg: lastRun.outcomeMsg
        })
      }
    } : {})
  };
  if (omitGeneratedValues) {
    if (rule.actions) {
      rule.actions = rule.actions.map(ruleAction => {
        return (0, _lodash.omit)(ruleAction, 'alertsFilter.query.dsl');
      });
    }
  }

  // Need the `rule` object to build a URL
  if (!excludeFromPublicApi) {
    const viewInAppRelativeUrl = opts.ruleType.getViewInAppRelativeUrl && opts.ruleType.getViewInAppRelativeUrl({
      rule
    });
    if (viewInAppRelativeUrl) {
      rule.viewInAppRelativeUrl = viewInAppRelativeUrl;
    }
  }
  if (includeLegacyId) {
    const result = {
      ...rule,
      legacyId
    };
    return result;
  }
  return rule;
}