"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getQueryDelaySettingsRoute = void 0;
var _types = require("../../../../types");
var _lib = require("../../../lib");
var _common = require("../../../../../common");
var _transforms = require("../../transforms");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getQueryDelaySettingsRoute = (router, licenseState) => {
  router.get({
    path: `${_types.INTERNAL_BASE_ALERTING_API_PATH}/rules/settings/_query_delay`,
    validate: {},
    options: {
      access: 'internal',
      tags: [`access:${_common.API_PRIVILEGES.READ_QUERY_DELAY_SETTINGS}`]
    }
  }, router.handleLegacyErrors((0, _lib.verifyAccessAndContext)(licenseState, async function (context, req, res) {
    const rulesSettingsClient = (await context.alerting).getRulesSettingsClient();
    const queryDelaySettings = await rulesSettingsClient.queryDelay().get();
    const response = (0, _transforms.transformQueryDelaySettingsToResponseV1)(queryDelaySettings);
    return res.ok(response);
  })));
};
exports.getQueryDelaySettingsRoute = getQueryDelaySettingsRoute;