"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.updateRuleApiKeyRoute = void 0;
var _update_api_key = require("../../../../../common/routes/rule/apis/update_api_key");
var _lib = require("../../../../lib");
var _types = require("../../../../types");
var _lib2 = require("../../../lib");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const updateRuleApiKeyRoute = (router, licenseState) => {
  router.post({
    path: `${_types.BASE_ALERTING_API_PATH}/rule/{id}/_update_api_key`,
    options: {
      access: 'public',
      summary: 'Update the API key for a rule',
      tags: ['oas-tag:alerting']
    },
    validate: {
      request: {
        params: _update_api_key.updateApiKeyParamsSchemaV1
      },
      response: {
        204: {
          description: 'Indicates a successful call.'
        },
        400: {
          description: 'Indicates an invalid schema or parameters.'
        },
        403: {
          description: 'Indicates that this call is forbidden.'
        },
        404: {
          description: 'Indicates a rule with the given ID does not exist.'
        },
        409: {
          description: 'Indicates that the rule has already been updated by another user.'
        }
      }
    }
  }, router.handleLegacyErrors((0, _lib2.verifyAccessAndContext)(licenseState, async function (context, req, res) {
    const rulesClient = (await context.alerting).getRulesClient();
    const {
      id
    } = req.params;
    try {
      await rulesClient.updateRuleApiKey({
        id
      });
      return res.noContent();
    } catch (e) {
      if (e instanceof _lib.RuleTypeDisabledError) {
        return e.sendResponse(res);
      }
      throw e;
    }
  })));
};
exports.updateRuleApiKeyRoute = updateRuleApiKeyRoute;