"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ruleTypesRoute = void 0;
var _list_types = require("../../../../../common/routes/rule/apis/list_types");
var _lib = require("../../../lib");
var _types = require("../../../../types");
var _transforms = require("./transforms");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ruleTypesRoute = (router, licenseState) => {
  router.get({
    path: `${_types.BASE_ALERTING_API_PATH}/rule_types`,
    options: {
      access: 'public',
      summary: `Get the rule types`,
      tags: ['oas-tag:alerting']
    },
    validate: {
      request: {},
      response: {
        200: {
          body: () => _list_types.typesRulesResponseSchemaV1,
          description: 'Indicates a successful call.'
        },
        401: {
          description: 'Authorization information is missing or invalid.'
        }
      }
    }
  }, router.handleLegacyErrors((0, _lib.verifyAccessAndContext)(licenseState, async function (context, req, res) {
    const rulesClient = (await context.alerting).getRulesClient();
    const ruleTypes = await rulesClient.listRuleTypes();
    const responseBody = (0, _transforms.transformRuleTypesResponseV1)(ruleTypes);
    return res.ok({
      body: responseBody
    });
  })));
};
exports.ruleTypesRoute = ruleTypesRoute;