"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.enableRuleRoute = void 0;
var _lib = require("../../../../lib");
var _types = require("../../../../types");
var _lib2 = require("../../../lib");
var _enable = require("../../../../../common/routes/rule/apis/enable");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const enableRuleRoute = (router, licenseState) => {
  router.post({
    path: `${_types.BASE_ALERTING_API_PATH}/rule/{id}/_enable`,
    options: {
      access: 'public',
      summary: 'Enable a rule',
      tags: ['oas-tag:alerting']
    },
    validate: {
      request: {
        params: _enable.enableRuleRequestParamsSchemaV1
      },
      response: {
        204: {
          description: 'Indicates a successful call.'
        },
        400: {
          description: 'Indicates an invalid schema or parameters.'
        },
        403: {
          description: 'Indicates that this call is forbidden.'
        },
        404: {
          description: 'Indicates a rule with the given ID does not exist.'
        }
      }
    }
  }, router.handleLegacyErrors((0, _lib2.verifyAccessAndContext)(licenseState, async function (context, req, res) {
    const rulesClient = (await context.alerting).getRulesClient();
    const params = req.params;
    try {
      await rulesClient.enableRule(params);
      return res.noContent();
    } catch (e) {
      if (e instanceof _lib.RuleTypeDisabledError) {
        return e.sendResponse(res);
      }
      throw e;
    }
  })));
};
exports.enableRuleRoute = enableRuleRoute;